/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.location;

import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.basestruct.Point;
import com.baidu.platform.comapi.basestruct.a;
import com.baidu.platform.comapi.location.CoordinateUtil;
import java.util.ArrayList;

public class CoordinateUtilEx {
    public static Point getGeoPointFromString(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        return CoordinateUtil.geoStringToPoint(string);
    }

    public static String getStringFromGeoPoint(Point point) {
        return CoordinateUtil.pointToGeoString(point);
    }

    @Deprecated
    public static a getGeoComplexPtBoundFromString(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        return CoordinateUtil.geoStringToComplexPtBound(string);
    }

    @Deprecated
    public static a getGeoComplexPointFromString(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        return CoordinateUtil.geoStringToComplexPt(string);
    }

    public static double getDistanceByMc(Point point, Point point2) {
        return CoordinateUtil.getDistanceByMc(point.getDoubleX(), point.getDoubleY(), point2.getDoubleX(), point2.getDoubleY());
    }

    public static double getDistanceByMc(GeoPoint geoPoint, GeoPoint geoPoint2) {
        return CoordinateUtil.getDistanceByMc(geoPoint.getLongitude(), geoPoint.getLatitude(), geoPoint2.getLongitude(), geoPoint2.getLatitude());
    }

    public static Point Coordinate_encryptEx(float f2, float f3, String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            string = "bd09ll";
        }
        switch (string) {
            case "wgs84": {
                return CoordinateUtil.wgs84Tobd09mc(f2, f3);
            }
            case "gcj02": {
                return CoordinateUtil.gcj02Tobd09mc(f2, f3);
            }
            case "bd09ll": {
                return CoordinateUtil.bd09llTobd09mc(f2, f3);
            }
            case "bd09mc": {
                return new Point(f2, f3);
            }
        }
        return null;
    }

    public static ArrayList<Point> Coordinate_encryptExArray(ArrayList<Point> arrayList, String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            string = "bd09ll";
        }
        if (!(string.equals("bd09ll") || string.equals("bd09mc") || string.equals("gcj02") || string.equals("wgs84"))) {
            return null;
        }
        float[] fArray = new float[arrayList.size()];
        float[] fArray2 = new float[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            fArray[i2] = (float)arrayList.get(i2).getIntX() / 100000.0f;
            fArray2[i2] = (float)arrayList.get(i2).getIntY() / 100000.0f;
        }
        ArrayList<Point> arrayList2 = new ArrayList<Point>();
        for (int i3 = 0; i3 < fArray.length; ++i3) {
            Point point = null;
            switch (string) {
                case "wgs84": {
                    point = CoordinateUtil.wgs84Tobd09mc(fArray[i3], fArray2[i3]);
                    break;
                }
                case "gcj02": {
                    point = CoordinateUtil.gcj02Tobd09mc(fArray[i3], fArray2[i3]);
                    break;
                }
                case "bd09ll": {
                    point = CoordinateUtil.bd09llTobd09mc(fArray[i3], fArray2[i3]);
                    break;
                }
                case "bd09mc": {
                    point = new Point(fArray[i3], fArray2[i3]);
                    break;
                }
            }
            if (point == null) continue;
            arrayList2.add(point);
        }
        return arrayList2;
    }
}

