/*
 * Copyright (C) 2015 Square, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.squareup.leakcanary.internal;

import java.util.concurrent.ThreadFactory;

/**
 * This is intended to only be used with a single thread executor.
 */
final class LeakCanarySingleThreadFactory implements ThreadFactory {

  private final String threadName;

  LeakCanarySingleThreadFactory(String threadName) {
    this.threadName = "LeakCanary-" + threadName;
  }

  @Override
  public Thread newThread(Runnable runnable) {
    return new Thread(runnable, threadName);
  }
}
