package com.didichuxing.doraemonkit.kit.timecounter

import android.app.Activity
import android.content.Context
import com.didichuxing.doraemonkit.R
import com.didichuxing.doraemonkit.kit.AbstractKit
import com.google.auto.service.AutoService

/**
 * app启动、页面跳转的计时kit
 */
@AutoService(AbstractKit::class)
class TimeCounterKit : AbstractKit() {
    override val name: Int
        get() = R.string.dk_kit_time_counter
    override val icon: Int
        get() = R.mipmap.dk_time_counter

    override fun onClickWithReturn(activity: Activity): Boolean {
        startUniversalActivity(TimeCounterFragment::class.java, activity, null, true)
        return true
    }

    override fun onAppInit(context: Context?) {}
    override val isInnerKit: Boolean
        get() = true

    override fun innerKitId(): String {
        return "dokit_sdk_performance_ck_open_coast"
    }
}