/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.map;

import java.io.Serializable;

public class MapStatus
implements Serializable {
    public float level;
    public int rotation;
    public int overlooking;
    public double centerPtX;
    public double centerPtY;
    public double centerPtZ;
    public WinRound winRound;
    public GeoBound geoRound;
    public float xOffset;
    public float yOffset;
    public boolean bfpp;
    public String panoId;
    public float streetIndicateAngle;
    public boolean isBirdEye;
    public int streetExt;
    public float roadOffsetX;
    public float roadOffsetY;
    public int hasAnimation;
    public int animationTime;
    public int animationType = 0;
    public boolean bOverlookSpringback;
    public int minOverlooking;

    public int hashCode() {
        double d2 = 1.0;
        d2 = 31.0 * d2 + this.centerPtX;
        d2 = 31.0 * d2 + this.centerPtY;
        d2 = 31.0 * d2 + this.centerPtZ;
        d2 = 31.0 * d2 + (double)(this.bfpp ? 1 : 0);
        d2 = 31.0 * d2 + (double)(this.geoRound == null ? 0 : this.geoRound.hashCode());
        d2 = 31.0 * d2 + (double)Float.floatToIntBits(this.level);
        d2 = 31.0 * d2 + (double)this.overlooking;
        d2 = 31.0 * d2 + (double)this.rotation;
        d2 = 31.0 * d2 + (double)(this.winRound == null ? 0 : this.winRound.hashCode());
        return (int)d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapStatus)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        MapStatus mapStatus = (MapStatus)object;
        if (this.centerPtX != mapStatus.centerPtX) {
            return false;
        }
        if (this.centerPtY != mapStatus.centerPtY) {
            return false;
        }
        if (this.centerPtZ != mapStatus.centerPtZ) {
            return false;
        }
        if (this.bfpp != mapStatus.bfpp) {
            return false;
        }
        if (this.geoRound == null ? mapStatus.geoRound != null : !this.geoRound.equals(mapStatus.geoRound)) {
            return false;
        }
        if (Float.floatToIntBits(this.level) != Float.floatToIntBits(mapStatus.level)) {
            return false;
        }
        if (this.overlooking != mapStatus.overlooking) {
            return false;
        }
        if (this.rotation != mapStatus.rotation) {
            return false;
        }
        if (this.yOffset != mapStatus.yOffset) {
            return false;
        }
        if (this.xOffset != mapStatus.xOffset) {
            return false;
        }
        return !(this.winRound == null ? mapStatus.winRound != null : !this.winRound.equals(mapStatus.winRound));
    }

    public MapStatus() {
        this.level = -1.0f;
        this.rotation = -1;
        this.overlooking = -1;
        this.centerPtX = -1.0;
        this.centerPtY = -1.0;
        this.centerPtZ = 0.0;
        this.xOffset = 0.0f;
        this.yOffset = 0.0f;
        this.winRound = new WinRound();
        this.geoRound = new GeoBound();
        this.bfpp = false;
        this.panoId = "";
        this.streetIndicateAngle = 0.0f;
        this.isBirdEye = false;
        this.streetExt = 0;
        this.roadOffsetX = 0.0f;
        this.roadOffsetY = 0.0f;
        this.bOverlookSpringback = false;
        this.minOverlooking = -1;
    }

    public MapStatus(MapStatus mapStatus) {
        this.level = mapStatus.level;
        this.rotation = mapStatus.rotation;
        this.overlooking = mapStatus.overlooking;
        this.centerPtX = mapStatus.centerPtX;
        this.centerPtY = mapStatus.centerPtY;
        this.centerPtZ = mapStatus.centerPtZ;
        this.xOffset = mapStatus.xOffset;
        this.yOffset = mapStatus.yOffset;
        this.winRound = mapStatus.winRound;
        this.geoRound = mapStatus.geoRound;
        this.bfpp = mapStatus.bfpp;
        this.panoId = mapStatus.panoId;
        this.streetIndicateAngle = mapStatus.streetIndicateAngle;
        this.isBirdEye = mapStatus.isBirdEye;
        this.streetExt = mapStatus.streetExt;
        this.roadOffsetX = mapStatus.roadOffsetX;
        this.roadOffsetY = mapStatus.roadOffsetY;
        this.bOverlookSpringback = mapStatus.bOverlookSpringback;
        this.minOverlooking = mapStatus.minOverlooking;
    }

    public String toString() {
        return "MapStatus{level=" + this.level + ", rotation=" + this.rotation + ", overlooking=" + this.overlooking + ", centerPtX=" + this.centerPtX + ", centerPtY=" + this.centerPtY + ", centerPtZ=" + this.centerPtZ + ", winRound=" + this.winRound + ", geoRound=" + this.geoRound + ", xOffset=" + this.xOffset + ", yOffset=" + this.yOffset + ", bfpp=" + this.bfpp + ", panoId='" + this.panoId + '\'' + ", streetIndicateAngle=" + this.streetIndicateAngle + ", isBirdEye=" + this.isBirdEye + ", streetExt=" + this.streetExt + ", roadOffsetX=" + this.roadOffsetX + ", roadOffsetY=" + this.roadOffsetY + '}';
    }

    public static class WinRound
    implements Serializable {
        public int left = 0;
        public int right = 0;
        public int top = 0;
        public int bottom = 0;

        public int hashCode() {
            int n2 = 1;
            n2 = 31 * n2 + this.bottom;
            n2 = 31 * n2 + this.left;
            n2 = 31 * n2 + this.right;
            n2 = 31 * n2 + this.top;
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof WinRound)) {
                return false;
            }
            WinRound winRound = (WinRound)object;
            if (this.bottom != winRound.bottom) {
                return false;
            }
            if (this.left != winRound.left) {
                return false;
            }
            if (this.right != winRound.right) {
                return false;
            }
            return this.top == winRound.top;
        }
    }

    public static class GeoBound
    implements Serializable {
        public long left = 0L;
        public long right = 0L;
        public long top = 0L;
        public long bottom = 0L;

        public int hashCode() {
            int n2 = 1;
            n2 = 31 * n2 + (int)(this.bottom ^ this.bottom >>> 32);
            n2 = 31 * n2 + (int)(this.left ^ this.left >>> 32);
            n2 = 31 * n2 + (int)(this.right ^ this.right >>> 32);
            n2 = 31 * n2 + (int)(this.top ^ this.top >>> 32);
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof GeoBound)) {
                return false;
            }
            GeoBound geoBound = (GeoBound)object;
            if (this.bottom != geoBound.bottom) {
                return false;
            }
            if (this.left != geoBound.left) {
                return false;
            }
            if (this.right != geoBound.right) {
                return false;
            }
            return this.top == geoBound.top;
        }
    }
}

