/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.vi;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.baidu.mapsdkplatform.comapi.util.SyncSysInfo;
import com.baidu.platform.comapi.util.NetworkUtil;
import com.baidu.platform.comapi.util.SysOSUtil;
import com.baidu.vi.VIContext;
import com.baidu.vi.VNetworkInfo;
import com.baidu.vi.e;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class VDeviceAPI {
    private static PowerManager.WakeLock a = null;
    private static BroadcastReceiver b = null;

    public static long getTotalSpace() {
        File file = Environment.getRootDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getBlockCount();
        return l2 * l3 / 1024L;
    }

    public static long getFreeSpace() {
        File file = Environment.getRootDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getAvailableBlocks();
        return l2 * l3 / 1024L;
    }

    public static long getSdcardTotalSpace() {
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getBlockCount();
        return l2 * l3 / 1024L;
    }

    public static long getSdcardFreeSpace() {
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getAvailableBlocks();
        return l2 * l3 / 1024L;
    }

    public static long getTotalMemory() {
        String string = "/proc/meminfo";
        long l2 = 0L;
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader, 8192);
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                String[] stringArray = string2.split("\\s+");
                l2 = Integer.valueOf(stringArray[1]).intValue();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l2;
    }

    public static long getAvailableMemory() {
        ActivityManager activityManager = (ActivityManager)VIContext.getContext().getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo.availMem / 1024L;
    }

    public static String getOsVersion() {
        return "android";
    }

    public static void setupSoftware(String string) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)new File(string)), "application/vnd.android.package-archive");
        VIContext.getContext().startActivity(intent);
    }

    public static String getModuleFileName() {
        return VIContext.getContext().getFilesDir().getAbsolutePath();
    }

    public static String getSdcardPath() {
        return SysOSUtil.getInstance().getCompatibleSdcardPath();
    }

    public static String getCachePath() {
        return Environment.getDataDirectory().getAbsolutePath();
    }

    public static String getAppVersion() {
        String string = VIContext.getContext().getApplicationInfo().packageName;
        try {
            return VIContext.getContext().getPackageManager().getPackageInfo((String)string, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return "";
        }
    }

    public static int getCurrentNetworkType() {
        int n2 = -1;
        try {
            n2 = Integer.parseInt(NetworkUtil.getCurrentNetMode(VIContext.getContext()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public static boolean isWifiConnected() {
        ConnectivityManager connectivityManager = (ConnectivityManager)VIContext.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static VNetworkInfo getNetworkInfo(int n2) {
        ConnectivityManager connectivityManager = (ConnectivityManager)VIContext.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        switch (n2) {
            case 2: {
                networkInfo = connectivityManager.getNetworkInfo(1);
                break;
            }
            case 3: {
                networkInfo = connectivityManager.getNetworkInfo(0);
                break;
            }
        }
        if (networkInfo != null) {
            return new VNetworkInfo(networkInfo);
        }
        return null;
    }

    @Deprecated
    public static int getTelecomInfo() {
        return -1;
    }

    public static void setNetworkChangedCallback() {
        VDeviceAPI.unsetNetworkChangedCallback();
        b = new e();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        VIContext.getContext().registerReceiver(b, intentFilter);
    }

    public static void unsetNetworkChangedCallback() {
        if (b != null) {
            VIContext.getContext().unregisterReceiver(b);
            b = null;
        }
    }

    public static native void onNetworkStateChanged();

    public static ScanResult[] getWifiHotpot() {
        return null;
    }

    public static float getSystemMetricsX() {
        if (VIContext.getContext() == null) {
            return 0.0f;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)VIContext.getContext().getSystemService("window");
        if (windowManager != null) {
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        }
        return displayMetrics.widthPixels;
    }

    public static float getSystemMetricsY() {
        if (VIContext.getContext() == null) {
            return 0.0f;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)VIContext.getContext().getSystemService("window");
        if (windowManager != null) {
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        }
        return displayMetrics.heightPixels;
    }

    public static float getScreenDensity() {
        if (VIContext.getContext() == null) {
            return 0.0f;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)VIContext.getContext().getSystemService("window");
        if (windowManager != null) {
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        }
        return displayMetrics.density;
    }

    public static int getScreenDensityDpi() {
        if (VIContext.getContext() == null) {
            return 0;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)VIContext.getContext().getSystemService("window");
        if (windowManager != null && windowManager.getDefaultDisplay() != null) {
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        }
        return displayMetrics.densityDpi;
    }

    public static void setScreenAlwaysOn(boolean bl) {
    }

    @TargetApi(value=8)
    public static int getScreenBrightness() {
        ContentResolver contentResolver = VIContext.getContext().getContentResolver();
        int n2 = 0;
        if (8 <= Build.VERSION.SDK_INT) {
            try {
                n2 = Settings.System.getInt((ContentResolver)contentResolver, (String)"screen_brightness_mode");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 == 1) {
            return -1;
        }
        String string = "screen_brightness";
        int n3 = 0;
        try {
            n3 = Settings.System.getInt((ContentResolver)contentResolver, (String)string);
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return -1;
        }
        return n3;
    }

    public static void makeCall(String string) {
    }

    public static void sendSMS(String string, String string2) {
    }

    public static int sendMMS(String string, String string2, String string3, String string4) {
        return 0;
    }

    public static void openUrl(String string) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string));
        VIContext.getContext().startActivity(intent);
    }

    public static String getCellId() {
        return "";
    }

    public static String getLac() {
        return "";
    }

    public static String getImei() {
        return null;
    }

    public static String getImsi() {
        TelephonyManager telephonyManager = (TelephonyManager)VIContext.getContext().getSystemService("phone");
        if (telephonyManager != null) {
            // empty if block
        }
        return null;
    }

    public static String getCuid() {
        return SyncSysInfo.getCid();
    }
}

