/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.b;
import java.util.List;

public final class LatLngBounds
implements Parcelable {
    public final LatLng northeast;
    public final LatLng southwest;
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new b();

    LatLngBounds(LatLng latLng, LatLng latLng2) {
        this.northeast = latLng;
        this.southwest = latLng2;
    }

    protected LatLngBounds(Parcel parcel) {
        this.northeast = (LatLng)parcel.readParcelable(LatLng.class.getClassLoader());
        this.southwest = (LatLng)parcel.readParcelable(LatLng.class.getClassLoader());
    }

    public boolean contains(LatLng latLng) {
        if (latLng == null) {
            return false;
        }
        double d2 = this.southwest.latitude;
        double d3 = this.northeast.latitude;
        double d4 = this.southwest.longitude;
        double d5 = this.northeast.longitude;
        double d6 = latLng.latitude;
        double d7 = latLng.longitude;
        return d6 >= d2 && d6 <= d3 && d7 >= d4 && d7 <= d5;
    }

    public LatLng getCenter() {
        double d2 = (this.northeast.latitude - this.southwest.latitude) / 2.0 + this.southwest.latitude;
        double d3 = (this.northeast.longitude - this.southwest.longitude) / 2.0 + this.southwest.longitude;
        LatLng latLng = new LatLng(d2, d3);
        return latLng;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeParcelable((Parcelable)this.northeast, n2);
        parcel.writeParcelable((Parcelable)this.southwest, n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("southwest: ");
        stringBuilder.append(this.southwest.latitude);
        stringBuilder.append(", ");
        stringBuilder.append(this.southwest.longitude);
        stringBuilder.append("\n");
        stringBuilder.append("northeast: ");
        stringBuilder.append(this.northeast.latitude);
        stringBuilder.append(", ");
        stringBuilder.append(this.northeast.longitude);
        return stringBuilder.toString();
    }

    public static final class Builder {
        private double a;
        private double b;
        private double c;
        private double d;
        private double e;
        private double f;
        private boolean g = true;

        public LatLngBounds build() {
            if (this.e != 0.0 || this.f != 0.0) {
                if (this.d != 0.0 || this.c != 0.0) {
                    this.c = this.f + 360.0;
                    if (this.c > this.d) {
                        double d2 = this.d;
                        this.d = this.c;
                        this.c = d2;
                    }
                } else {
                    this.d = this.e;
                    this.c = this.f;
                }
            }
            LatLng latLng = new LatLng(this.b, this.d);
            LatLng latLng2 = new LatLng(this.a, this.c);
            return new LatLngBounds(latLng, latLng2);
        }

        public Builder include(LatLng latLng) {
            if (latLng == null) {
                return this;
            }
            if (this.g) {
                this.g = false;
                if (latLng.longitude >= 0.0) {
                    this.d = this.c = latLng.longitude;
                } else {
                    this.e = this.f = latLng.longitude;
                }
                this.b = this.a = latLng.latitude;
            }
            this.a(latLng);
            return this;
        }

        public Builder include(List<LatLng> list) {
            if (list == null || list.size() == 0) {
                return this;
            }
            if (list.get(0) != null && this.g) {
                this.g = false;
                if (list.get((int)0).longitude >= 0.0) {
                    this.d = this.c = list.get((int)0).longitude;
                } else {
                    this.e = this.f = list.get((int)0).longitude;
                }
                this.b = this.a = list.get((int)0).latitude;
            }
            for (LatLng latLng : list) {
                this.a(latLng);
            }
            return this;
        }

        private void a(LatLng latLng) {
            if (latLng == null) {
                return;
            }
            double d2 = latLng.latitude;
            double d3 = latLng.longitude;
            if (d2 < this.a) {
                this.a = d2;
            }
            if (d2 > this.b) {
                this.b = d2;
            }
            if (d3 >= 0.0) {
                if (d3 < this.c) {
                    this.c = d3;
                }
                if (d3 > this.d) {
                    this.d = d3;
                    if (this.c == 0.0) {
                        this.c = d3;
                    }
                }
            } else {
                if (d3 < this.e) {
                    this.e = d3;
                    if (this.f == 0.0) {
                        this.f = d3;
                    }
                }
                if (d3 > this.f) {
                    this.f = d3;
                }
            }
        }
    }
}

