/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

public class NetworkUtil {
    public static final int NETYPE_NOCON = -1;
    public static final int NETYPE_UNKNOWN = 0;
    public static final int NETYPE_WIFI = 1;
    public static final int NETYPE_2G = 2;
    public static final int NETYPE_3G = 3;
    public static final int NETYPE_4G = 4;
    public static final int NETYPE_TELECOM_2G = 5;
    public static final int NETYPE_MOBILE_UNICOM_2G = 6;
    public static final int NETYPE_TELECOM_3G = 7;
    public static final int NETYPE_MOBILE_3G = 8;
    public static final int NETYPE_UNICOM_3G = 9;
    public static final int NETYPE_4G_UNKNOWN = 10;
    public static boolean mUseProxy = false;
    public static String mProxyHost = "";
    public static int mProxyPort = 0;

    public static void updateNetworkProxy(Context context) {
    }

    public static boolean initConnectState() {
        return true;
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            if (connectivityManager != null) {
                return connectivityManager.getActiveNetworkInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static NetworkInfo[] getAllNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo[] networkInfoArray = null;
        try {
            networkInfoArray = connectivityManager.getAllNetworkInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return networkInfoArray;
    }

    public static String getCurrentNetMode(Context context) {
        int n2 = -1;
        NetworkInfo networkInfo = NetworkUtil.getActiveNetworkInfo(context);
        if (null != networkInfo) {
            int n3 = networkInfo.getType();
            if (n3 == 1) {
                n2 = 1;
            } else if (n3 == 0 || n3 == 3 || n3 == 4 || n3 == 5) {
                if (Build.VERSION.SDK_INT > 29) {
                    String string = "mobile";
                    ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    if (connectivityManager == null) {
                        return string;
                    }
                    Network network = connectivityManager.getActiveNetwork();
                    NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                    if (networkCapabilities != null) {
                        boolean bl = networkCapabilities.hasTransport(1);
                        boolean bl2 = networkCapabilities.hasTransport(0);
                        boolean bl3 = networkCapabilities.hasTransport(3);
                        boolean bl4 = networkCapabilities.hasTransport(6);
                        boolean bl5 = networkCapabilities.hasTransport(4);
                        boolean bl6 = networkCapabilities.hasTransport(5);
                        if (bl) {
                            string = "WIFI";
                        } else if (bl2) {
                            string = "CELLULAR";
                        } else if (bl3) {
                            string = "ETHERNET";
                        } else if (bl4) {
                            string = "LoWPAN";
                        } else if (bl5) {
                            string = "VPN";
                        } else if (bl6) {
                            string = "WifiAware";
                        }
                    }
                    return string;
                }
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager != null) {
                    int n4 = telephonyManager.getNetworkType();
                    switch (n4) {
                        case 7: 
                        case 11: 
                        case 16: {
                            n2 = 2;
                            break;
                        }
                        case 13: 
                        case 18: {
                            n2 = 4;
                            break;
                        }
                        case 4: {
                            n2 = 5;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 6;
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 12: {
                            n2 = 7;
                            break;
                        }
                        case 8: 
                        case 17: {
                            n2 = 8;
                            break;
                        }
                        case 3: 
                        case 9: 
                        case 10: 
                        case 15: {
                            n2 = 9;
                            break;
                        }
                        case 14: {
                            n2 = 3;
                            break;
                        }
                        default: {
                            n2 = 0;
                        }
                    }
                }
            }
        } else {
            n2 = -1;
        }
        return Integer.toString(n2);
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            if (NetworkUtil.isWifiConnected(context)) {
                return true;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnectedOrConnecting();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWifiConnected(Context context) {
        if (context == null) {
            return false;
        }
        boolean bl = false;
        try {
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null) {
                bl = 1 == networkInfo.getType() && networkInfo.isConnected();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isWifiState(Context context) {
        if (context == null) {
            return false;
        }
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        int n2 = 1;
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                if (0 == context.checkSelfPermission("android.permission.ACCESS_WIFI_STATE")) {
                    n2 = wifiManager.getWifiState();
                }
            } else {
                n2 = wifiManager.getWifiState();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2 == 3;
    }

    public static String getNetworkOperatorInfo(Context context) {
        String string;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null && !TextUtils.isEmpty((CharSequence)(string = telephonyManager.getNetworkOperator()))) {
            try {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.insert(3, ":");
                return stringBuilder.toString();
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public static int getNetworkOperatorType(Context context) {
        String string = NetworkUtil.getNetworkOperatorInfo(context);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (string.startsWith("460:00") || string.startsWith("460:02")) {
                return 0;
            }
            if (string.startsWith("460:01")) {
                return 1;
            }
            if (string.startsWith("460:03")) {
                return 2;
            }
        }
        return -1;
    }
}

