// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// SetGwDefaultExportRequest is request schema for SetGwDefaultExport action
type SetGwDefaultExportRequest struct {
	request.CommonBase

	// [公共参数] 项目Id。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// NAT网关绑定的EIP Id。ExportIp和ExportEipId必填一个
	ExportEipId *string `required:"false"`

	// NAT网关绑定的EIP。ExportIp和ExportEipId必填一个
	ExportIp *string `required:"false"`

	// NAT网关Id
	NATGWId *string `required:"true"`
}

// SetGwDefaultExportResponse is response schema for SetGwDefaultExport action
type SetGwDefaultExportResponse struct {
	response.CommonBase
}

// NewSetGwDefaultExportRequest will create request of SetGwDefaultExport action.
func (c *VPCClient) NewSetGwDefaultExportRequest() *SetGwDefaultExportRequest {
	req := &SetGwDefaultExportRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// SetGwDefaultExport - 设置NAT网关的默认出口
func (c *VPCClient) SetGwDefaultExport(req *SetGwDefaultExportRequest) (*SetGwDefaultExportResponse, error) {
	var err error
	var res SetGwDefaultExportResponse

	reqCopier := *req

	err = c.Client.InvokeAction("SetGwDefaultExport", &reqCopier, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
