// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/containerregistry/v1/registry_service.proto

package containerregistry

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetRegistryRequest struct {
	// ID of the Registry resource to return.
	//
	// To get the registry ID use a [RegistryService.List] request.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRegistryRequest) Reset()         { *m = GetRegistryRequest{} }
func (m *GetRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*GetRegistryRequest) ProtoMessage()    {}
func (*GetRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{0}
}

func (m *GetRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRegistryRequest.Unmarshal(m, b)
}
func (m *GetRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRegistryRequest.Marshal(b, m, deterministic)
}
func (m *GetRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRegistryRequest.Merge(m, src)
}
func (m *GetRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_GetRegistryRequest.Size(m)
}
func (m *GetRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRegistryRequest proto.InternalMessageInfo

func (m *GetRegistryRequest) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type ListRegistriesRequest struct {
	// ID of the folder to list registries in.
	//
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListRegistriesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListRegistriesResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on [Registry.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. Value or a list of values to compare against the values of the field.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRegistriesRequest) Reset()         { *m = ListRegistriesRequest{} }
func (m *ListRegistriesRequest) String() string { return proto.CompactTextString(m) }
func (*ListRegistriesRequest) ProtoMessage()    {}
func (*ListRegistriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{1}
}

func (m *ListRegistriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRegistriesRequest.Unmarshal(m, b)
}
func (m *ListRegistriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRegistriesRequest.Marshal(b, m, deterministic)
}
func (m *ListRegistriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRegistriesRequest.Merge(m, src)
}
func (m *ListRegistriesRequest) XXX_Size() int {
	return xxx_messageInfo_ListRegistriesRequest.Size(m)
}
func (m *ListRegistriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRegistriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRegistriesRequest proto.InternalMessageInfo

func (m *ListRegistriesRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListRegistriesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListRegistriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListRegistriesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListRegistriesResponse struct {
	// List of Registry resources.
	Registries []*Registry `protobuf:"bytes,1,rep,name=registries,proto3" json:"registries,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListRegistriesRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListRegistriesRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRegistriesResponse) Reset()         { *m = ListRegistriesResponse{} }
func (m *ListRegistriesResponse) String() string { return proto.CompactTextString(m) }
func (*ListRegistriesResponse) ProtoMessage()    {}
func (*ListRegistriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{2}
}

func (m *ListRegistriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRegistriesResponse.Unmarshal(m, b)
}
func (m *ListRegistriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRegistriesResponse.Marshal(b, m, deterministic)
}
func (m *ListRegistriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRegistriesResponse.Merge(m, src)
}
func (m *ListRegistriesResponse) XXX_Size() int {
	return xxx_messageInfo_ListRegistriesResponse.Size(m)
}
func (m *ListRegistriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRegistriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRegistriesResponse proto.InternalMessageInfo

func (m *ListRegistriesResponse) GetRegistries() []*Registry {
	if m != nil {
		return m.Registries
	}
	return nil
}

func (m *ListRegistriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateRegistryRequest struct {
	// ID of the folder to create a registry in.
	//
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the registry.
	//
	// There may be only one registry per folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels               map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateRegistryRequest) Reset()         { *m = CreateRegistryRequest{} }
func (m *CreateRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*CreateRegistryRequest) ProtoMessage()    {}
func (*CreateRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{3}
}

func (m *CreateRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateRegistryRequest.Unmarshal(m, b)
}
func (m *CreateRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateRegistryRequest.Marshal(b, m, deterministic)
}
func (m *CreateRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateRegistryRequest.Merge(m, src)
}
func (m *CreateRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_CreateRegistryRequest.Size(m)
}
func (m *CreateRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateRegistryRequest proto.InternalMessageInfo

func (m *CreateRegistryRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateRegistryRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type CreateRegistryMetadata struct {
	// ID of the registry that is being created.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateRegistryMetadata) Reset()         { *m = CreateRegistryMetadata{} }
func (m *CreateRegistryMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateRegistryMetadata) ProtoMessage()    {}
func (*CreateRegistryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{4}
}

func (m *CreateRegistryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateRegistryMetadata.Unmarshal(m, b)
}
func (m *CreateRegistryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateRegistryMetadata.Marshal(b, m, deterministic)
}
func (m *CreateRegistryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateRegistryMetadata.Merge(m, src)
}
func (m *CreateRegistryMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateRegistryMetadata.Size(m)
}
func (m *CreateRegistryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateRegistryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateRegistryMetadata proto.InternalMessageInfo

func (m *CreateRegistryMetadata) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type UpdateRegistryRequest struct {
	// ID of the Registry resource to update.
	//
	// To get the registry ID use a [RegistryService.List] request.
	RegistryId string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	// Field mask that specifies which fields of the Registry resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the registry.
	//
	// There may be only one registry per folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateRegistryRequest) Reset()         { *m = UpdateRegistryRequest{} }
func (m *UpdateRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateRegistryRequest) ProtoMessage()    {}
func (*UpdateRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{5}
}

func (m *UpdateRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRegistryRequest.Unmarshal(m, b)
}
func (m *UpdateRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRegistryRequest.Marshal(b, m, deterministic)
}
func (m *UpdateRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRegistryRequest.Merge(m, src)
}
func (m *UpdateRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateRegistryRequest.Size(m)
}
func (m *UpdateRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRegistryRequest proto.InternalMessageInfo

func (m *UpdateRegistryRequest) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

func (m *UpdateRegistryRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateRegistryRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateRegistryMetadata struct {
	// ID of the Registry resource that is being updated.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateRegistryMetadata) Reset()         { *m = UpdateRegistryMetadata{} }
func (m *UpdateRegistryMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateRegistryMetadata) ProtoMessage()    {}
func (*UpdateRegistryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{6}
}

func (m *UpdateRegistryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRegistryMetadata.Unmarshal(m, b)
}
func (m *UpdateRegistryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRegistryMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateRegistryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRegistryMetadata.Merge(m, src)
}
func (m *UpdateRegistryMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateRegistryMetadata.Size(m)
}
func (m *UpdateRegistryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRegistryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRegistryMetadata proto.InternalMessageInfo

func (m *UpdateRegistryMetadata) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type DeleteRegistryRequest struct {
	// ID of the registry to delete.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRegistryRequest) Reset()         { *m = DeleteRegistryRequest{} }
func (m *DeleteRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteRegistryRequest) ProtoMessage()    {}
func (*DeleteRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{7}
}

func (m *DeleteRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteRegistryRequest.Unmarshal(m, b)
}
func (m *DeleteRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteRegistryRequest.Marshal(b, m, deterministic)
}
func (m *DeleteRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRegistryRequest.Merge(m, src)
}
func (m *DeleteRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteRegistryRequest.Size(m)
}
func (m *DeleteRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRegistryRequest proto.InternalMessageInfo

func (m *DeleteRegistryRequest) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type DeleteRegistryMetadata struct {
	// ID of the registry that is being deleted.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRegistryMetadata) Reset()         { *m = DeleteRegistryMetadata{} }
func (m *DeleteRegistryMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteRegistryMetadata) ProtoMessage()    {}
func (*DeleteRegistryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{8}
}

func (m *DeleteRegistryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteRegistryMetadata.Unmarshal(m, b)
}
func (m *DeleteRegistryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteRegistryMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteRegistryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRegistryMetadata.Merge(m, src)
}
func (m *DeleteRegistryMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteRegistryMetadata.Size(m)
}
func (m *DeleteRegistryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRegistryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRegistryMetadata proto.InternalMessageInfo

func (m *DeleteRegistryMetadata) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

func init() {
	proto.RegisterType((*GetRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.GetRegistryRequest")
	proto.RegisterType((*ListRegistriesRequest)(nil), "yandex.cloud.containerregistry.v1.ListRegistriesRequest")
	proto.RegisterType((*ListRegistriesResponse)(nil), "yandex.cloud.containerregistry.v1.ListRegistriesResponse")
	proto.RegisterType((*CreateRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.CreateRegistryRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.containerregistry.v1.CreateRegistryRequest.LabelsEntry")
	proto.RegisterType((*CreateRegistryMetadata)(nil), "yandex.cloud.containerregistry.v1.CreateRegistryMetadata")
	proto.RegisterType((*UpdateRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.UpdateRegistryRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.containerregistry.v1.UpdateRegistryRequest.LabelsEntry")
	proto.RegisterType((*UpdateRegistryMetadata)(nil), "yandex.cloud.containerregistry.v1.UpdateRegistryMetadata")
	proto.RegisterType((*DeleteRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.DeleteRegistryRequest")
	proto.RegisterType((*DeleteRegistryMetadata)(nil), "yandex.cloud.containerregistry.v1.DeleteRegistryMetadata")
}

func init() {
	proto.RegisterFile("yandex/cloud/containerregistry/v1/registry_service.proto", fileDescriptor_9e6479678b0fb5ad)
}

var fileDescriptor_9e6479678b0fb5ad = []byte{
	// 1020 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x97, 0x41, 0x6f, 0x1b, 0x45,
	0x14, 0xc7, 0x35, 0xb1, 0x6b, 0xc5, 0xcf, 0x45, 0x2d, 0xa3, 0xba, 0xb2, 0x2c, 0x2a, 0x9c, 0xad,
	0x14, 0x52, 0xc3, 0xee, 0x7a, 0xd3, 0x26, 0xc4, 0x69, 0x2a, 0x54, 0x37, 0x4d, 0x15, 0x68, 0x05,
	0xda, 0x80, 0x10, 0x44, 0x95, 0x99, 0x78, 0x27, 0x66, 0xc8, 0x66, 0xd7, 0xec, 0xac, 0xad, 0x26,
	0xa5, 0x97, 0xde, 0x88, 0x84, 0x38, 0x20, 0x8e, 0x5c, 0x38, 0xf0, 0x01, 0x72, 0xeb, 0x91, 0x93,
	0x73, 0x25, 0xf0, 0x11, 0x38, 0x70, 0x6d, 0x8f, 0x48, 0x48, 0x68, 0x67, 0x76, 0xdd, 0xac, 0xbd,
	0x26, 0xeb, 0x70, 0xe9, 0xc9, 0xb3, 0x3b, 0xef, 0xbd, 0xf9, 0xfd, 0xe7, 0xbd, 0x37, 0xe3, 0x85,
	0xa5, 0x3d, 0xe2, 0x58, 0xf4, 0x91, 0xde, 0xb2, 0xdd, 0xae, 0xa5, 0xb7, 0x5c, 0xc7, 0x27, 0xcc,
	0xa1, 0x9e, 0x47, 0xdb, 0x8c, 0xfb, 0xde, 0x9e, 0xde, 0x33, 0xf4, 0x68, 0xdc, 0xe4, 0xd4, 0xeb,
	0xb1, 0x16, 0xd5, 0x3a, 0x9e, 0xeb, 0xbb, 0x78, 0x46, 0x7a, 0x6a, 0xc2, 0x53, 0x1b, 0xf1, 0xd4,
	0x7a, 0x46, 0xb9, 0x12, 0x0b, 0x4e, 0x3a, 0x4c, 0x77, 0x3b, 0xd4, 0x23, 0x3e, 0x73, 0x1d, 0x19,
	0x64, 0xd8, 0xa2, 0xd5, 0xa2, 0x9c, 0x87, 0x3f, 0xa1, 0x45, 0x2d, 0x3d, 0x60, 0xe8, 0x31, 0x1b,
	0xf3, 0x18, 0xac, 0x38, 0xb2, 0xf6, 0x95, 0x98, 0x5d, 0x8f, 0xd8, 0xcc, 0x8a, 0xa1, 0xb5, 0x5d,
	0xb7, 0x6d, 0x53, 0x5d, 0x3c, 0x6d, 0x75, 0xb7, 0xf5, 0x6d, 0x46, 0x6d, 0xab, 0xb9, 0x4b, 0xf8,
	0x4e, 0x68, 0xf1, 0x46, 0x68, 0x11, 0x08, 0x23, 0x8e, 0xe3, 0xfa, 0xc2, 0x3d, 0x04, 0x57, 0xee,
	0x00, 0xbe, 0x47, 0x7d, 0x33, 0x64, 0x33, 0xe9, 0xd7, 0x5d, 0xca, 0x7d, 0xac, 0x42, 0x61, 0xb0,
	0x9f, 0xcc, 0x2a, 0xa1, 0x0a, 0x9a, 0xcb, 0x37, 0xce, 0xff, 0xd5, 0x37, 0xd0, 0xc1, 0x91, 0x91,
	0x5d, 0xb9, 0xb5, 0x50, 0x33, 0x21, 0x32, 0x58, 0xb7, 0x94, 0x67, 0x08, 0x8a, 0xf7, 0x19, 0x8f,
	0xc2, 0x30, 0xca, 0xa3, 0x40, 0xd7, 0x20, 0xbf, 0xed, 0xda, 0x16, 0xf5, 0xc6, 0x85, 0x99, 0x96,
	0xd3, 0xeb, 0x16, 0x7e, 0x0b, 0xf2, 0x1d, 0xd2, 0xa6, 0x4d, 0xce, 0xf6, 0x69, 0x69, 0xaa, 0x82,
	0xe6, 0x32, 0x0d, 0xf8, 0xbb, 0x6f, 0xe4, 0x56, 0x6e, 0x19, 0xb5, 0x5a, 0xcd, 0x9c, 0x0e, 0x26,
	0x37, 0xd8, 0x3e, 0xc5, 0x73, 0x00, 0xc2, 0xd0, 0x77, 0x77, 0xa8, 0x53, 0xca, 0x88, 0xa0, 0xf9,
	0x83, 0x23, 0xe3, 0x9c, 0xb0, 0x34, 0x45, 0x94, 0x8f, 0x83, 0x39, 0xac, 0x40, 0x6e, 0x9b, 0xd9,
	0x3e, 0xf5, 0x4a, 0x59, 0x61, 0x05, 0x07, 0x47, 0x83, 0x78, 0xe1, 0x8c, 0xf2, 0x1d, 0x82, 0xcb,
	0xc3, 0xec, 0xbc, 0xe3, 0x3a, 0x9c, 0xe2, 0x0f, 0x20, 0x12, 0xc9, 0x28, 0x2f, 0xa1, 0x4a, 0x66,
	0xae, 0x30, 0xff, 0xb6, 0x76, 0x6a, 0x41, 0x69, 0x83, 0xdd, 0x3c, 0xe1, 0x8e, 0x67, 0xe1, 0x82,
	0x43, 0x1f, 0xf9, 0xcd, 0x13, 0xe8, 0x81, 0xc8, 0xbc, 0xf9, 0x5a, 0xf0, 0xfa, 0xa3, 0x88, 0x59,
	0xf9, 0x63, 0x0a, 0x8a, 0x77, 0x3c, 0x4a, 0x7c, 0x3a, 0x9c, 0x94, 0x09, 0xf6, 0x72, 0x01, 0xb2,
	0x0e, 0xd9, 0x95, 0xdb, 0x98, 0x6f, 0xcc, 0xbc, 0xe8, 0x1b, 0x57, 0xbe, 0xd9, 0x24, 0xea, 0xfe,
	0xc3, 0x4d, 0x95, 0xa8, 0xfb, 0x35, 0xb5, 0xfe, 0xf0, 0xb1, 0xf1, 0xce, 0xa2, 0xf1, 0x64, 0x33,
	0x7c, 0x32, 0x85, 0x39, 0xfe, 0x09, 0x41, 0xce, 0x26, 0x5b, 0xd4, 0xe6, 0xa5, 0x8c, 0x50, 0xbb,
	0x9a, 0x42, 0x6d, 0x22, 0xac, 0x76, 0x5f, 0x84, 0xb9, 0xeb, 0xf8, 0xde, 0x5e, 0xe3, 0xbd, 0x17,
	0x7d, 0xa3, 0xb0, 0xa9, 0x36, 0x6b, 0x6a, 0x3d, 0x60, 0xa8, 0x3e, 0x15, 0xc0, 0x8b, 0x37, 0x24,
	0xf8, 0xe2, 0xf5, 0xc3, 0x23, 0x23, 0x57, 0xce, 0x1a, 0xaa, 0x18, 0x61, 0x7c, 0x31, 0x24, 0x1d,
	0xd8, 0x9b, 0x21, 0x54, 0xb9, 0x0e, 0x85, 0x13, 0x71, 0xf1, 0x45, 0xc8, 0xec, 0xd0, 0x3d, 0xb9,
	0x15, 0x66, 0x30, 0xc4, 0x97, 0xe0, 0x5c, 0x8f, 0xd8, 0xdd, 0x50, 0xb8, 0x29, 0x1f, 0x96, 0xa7,
	0x96, 0x90, 0x52, 0x87, 0xcb, 0x71, 0xd0, 0x07, 0xd4, 0x27, 0x16, 0xf1, 0x09, 0x7e, 0x33, 0xa1,
	0xd6, 0x63, 0xd5, 0xfd, 0x63, 0x06, 0x8a, 0x9f, 0x74, 0xac, 0x84, 0x8c, 0x4c, 0xd6, 0x26, 0xf8,
	0x26, 0x14, 0xba, 0x22, 0x8e, 0x68, 0x4f, 0xc1, 0x58, 0x98, 0x2f, 0x6b, 0xb2, 0x3f, 0xb5, 0xa8,
	0x83, 0xb5, 0xb5, 0xa0, 0x83, 0x1f, 0x10, 0xbe, 0x63, 0x82, 0x34, 0x0f, 0xc6, 0x83, 0x94, 0x66,
	0xce, 0x9c, 0xd2, 0x6c, 0xea, 0x94, 0x26, 0xaa, 0x7d, 0x15, 0x53, 0x1a, 0x07, 0x4d, 0x9f, 0xd2,
	0x35, 0x28, 0xae, 0x52, 0x9b, 0xfe, 0xdf, 0x8c, 0x06, 0x08, 0xf1, 0x38, 0xa9, 0x11, 0xe6, 0x9f,
	0x9f, 0x87, 0x0b, 0x91, 0xd7, 0x86, 0xbc, 0xb2, 0xf0, 0xcf, 0x08, 0x32, 0xf7, 0xa8, 0x8f, 0x17,
	0x52, 0xe4, 0x68, 0xf4, 0xd4, 0x2e, 0x4f, 0x72, 0x36, 0x29, 0xef, 0x3e, 0xfd, 0xfd, 0xcf, 0x1f,
	0xa6, 0x0c, 0xac, 0xbf, 0xbc, 0xad, 0xd4, 0x84, 0xeb, 0x8a, 0x51, 0xae, 0x3f, 0x3e, 0xa1, 0xe4,
	0x09, 0xfe, 0x05, 0x41, 0x36, 0x38, 0x30, 0xf1, 0x52, 0x8a, 0xe5, 0x12, 0x6f, 0x85, 0x72, 0xfd,
	0x0c, 0x9e, 0xf2, 0x4c, 0x56, 0xae, 0x09, 0xec, 0xab, 0x78, 0xe6, 0x54, 0x6c, 0xfc, 0x0c, 0x41,
	0x4e, 0xf6, 0x7c, 0x2a, 0xd4, 0xc4, 0x73, 0xac, 0x3c, 0x13, 0xf7, 0x7c, 0x79, 0x3b, 0x7f, 0x18,
	0x8d, 0x14, 0xf3, 0xf0, 0xb8, 0xaa, 0x8c, 0x3d, 0x5e, 0xa6, 0xa3, 0x37, 0x02, 0x7c, 0x56, 0x39,
	0x1d, 0x7c, 0x19, 0x55, 0x71, 0x1f, 0x41, 0x4e, 0x16, 0x77, 0x2a, 0xf6, 0xc4, 0x86, 0x4d, 0xc3,
	0xfe, 0x85, 0x64, 0x1f, 0xd3, 0x47, 0x71, 0xf6, 0x1b, 0xf3, 0x93, 0xd6, 0x4a, 0xa0, 0xe4, 0x37,
	0x04, 0x39, 0xd9, 0x23, 0xa9, 0x94, 0x24, 0xb6, 0x65, 0x1a, 0x25, 0x5f, 0x1d, 0x1e, 0x57, 0xf5,
	0xb1, 0xed, 0x58, 0x1c, 0x3e, 0x64, 0xef, 0xee, 0x76, 0x7c, 0x29, 0xcb, 0xa8, 0x4e, 0xdc, 0x02,
	0xbf, 0x22, 0xc0, 0x41, 0x7d, 0xde, 0x16, 0x7f, 0x01, 0x1b, 0xcc, 0xb1, 0x98, 0xd3, 0xe6, 0x58,
	0x8b, 0x53, 0x86, 0x7f, 0x10, 0x47, 0x0d, 0x23, 0x55, 0x7a, 0x6a, 0xfb, 0xb0, 0xf8, 0xdf, 0x17,
	0xc0, 0xab, 0xb8, 0x91, 0x0a, 0x98, 0xbb, 0x5d, 0xaf, 0x45, 0x45, 0x1e, 0xec, 0x51, 0xd8, 0xe7,
	0x08, 0x5e, 0xdf, 0xa0, 0xc3, 0x6f, 0xd5, 0x44, 0xa4, 0x11, 0xbb, 0x09, 0xf2, 0xf2, 0x2d, 0x3a,
	0x3c, 0xae, 0xd6, 0xa1, 0x32, 0x2e, 0x54, 0x9a, 0x14, 0xad, 0x29, 0xb7, 0x27, 0x55, 0xcc, 0x87,
	0xd7, 0x09, 0x6a, 0xf1, 0x1f, 0x04, 0x97, 0x64, 0xa9, 0x0f, 0xc9, 0xae, 0x25, 0xca, 0x4e, 0x32,
	0x9d, 0x40, 0xf9, 0xf7, 0x81, 0xf2, 0x15, 0xb8, 0xfa, 0x1f, 0xd1, 0xd2, 0x88, 0x5f, 0x57, 0x56,
	0x27, 0x15, 0xdf, 0x4d, 0x58, 0x6a, 0x19, 0x55, 0x1b, 0x9f, 0x7d, 0xfe, 0x69, 0x9b, 0xf9, 0x5f,
	0x76, 0xb7, 0xb4, 0x96, 0xbb, 0xab, 0x4b, 0x01, 0xaa, 0xfc, 0xb0, 0x68, 0xbb, 0x6a, 0x9b, 0x3a,
	0x62, 0x79, 0xfd, 0xd4, 0x6f, 0x99, 0x9b, 0x23, 0x2f, 0xb7, 0x72, 0xc2, 0xf5, 0xfa, 0xbf, 0x01,
	0x00, 0x00, 0xff, 0xff, 0x9d, 0x6e, 0x20, 0xdc, 0xaa, 0x0d, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// RegistryServiceClient is the client API for RegistryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RegistryServiceClient interface {
	// Returns the specified Registry resource.
	//
	// To get the list of available Registry resources, make a [List] request.
	Get(ctx context.Context, in *GetRegistryRequest, opts ...grpc.CallOption) (*Registry, error)
	// Retrieves the list of Registry resources in the specified folder.
	List(ctx context.Context, in *ListRegistriesRequest, opts ...grpc.CallOption) (*ListRegistriesResponse, error)
	// Creates a registry in the specified folder.
	Create(ctx context.Context, in *CreateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified registry.
	Update(ctx context.Context, in *UpdateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified registry.
	Delete(ctx context.Context, in *DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists access bindings for the specified registry.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the specified registry.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified registry.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type registryServiceClient struct {
	cc *grpc.ClientConn
}

func NewRegistryServiceClient(cc *grpc.ClientConn) RegistryServiceClient {
	return &registryServiceClient{cc}
}

func (c *registryServiceClient) Get(ctx context.Context, in *GetRegistryRequest, opts ...grpc.CallOption) (*Registry, error) {
	out := new(Registry)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) List(ctx context.Context, in *ListRegistriesRequest, opts ...grpc.CallOption) (*ListRegistriesResponse, error) {
	out := new(ListRegistriesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Create(ctx context.Context, in *CreateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Update(ctx context.Context, in *UpdateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Delete(ctx context.Context, in *DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/ListAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/SetAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/UpdateAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RegistryServiceServer is the server API for RegistryService service.
type RegistryServiceServer interface {
	// Returns the specified Registry resource.
	//
	// To get the list of available Registry resources, make a [List] request.
	Get(context.Context, *GetRegistryRequest) (*Registry, error)
	// Retrieves the list of Registry resources in the specified folder.
	List(context.Context, *ListRegistriesRequest) (*ListRegistriesResponse, error)
	// Creates a registry in the specified folder.
	Create(context.Context, *CreateRegistryRequest) (*operation.Operation, error)
	// Updates the specified registry.
	Update(context.Context, *UpdateRegistryRequest) (*operation.Operation, error)
	// Deletes the specified registry.
	Delete(context.Context, *DeleteRegistryRequest) (*operation.Operation, error)
	// Lists access bindings for the specified registry.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the specified registry.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified registry.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
}

// UnimplementedRegistryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRegistryServiceServer struct {
}

func (*UnimplementedRegistryServiceServer) Get(ctx context.Context, req *GetRegistryRequest) (*Registry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedRegistryServiceServer) List(ctx context.Context, req *ListRegistriesRequest) (*ListRegistriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedRegistryServiceServer) Create(ctx context.Context, req *CreateRegistryRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedRegistryServiceServer) Update(ctx context.Context, req *UpdateRegistryRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedRegistryServiceServer) Delete(ctx context.Context, req *DeleteRegistryRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedRegistryServiceServer) ListAccessBindings(ctx context.Context, req *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (*UnimplementedRegistryServiceServer) SetAccessBindings(ctx context.Context, req *access.SetAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAccessBindings not implemented")
}
func (*UnimplementedRegistryServiceServer) UpdateAccessBindings(ctx context.Context, req *access.UpdateAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessBindings not implemented")
}

func RegisterRegistryServiceServer(s *grpc.Server, srv RegistryServiceServer) {
	s.RegisterService(&_RegistryService_serviceDesc, srv)
}

func _RegistryService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Get(ctx, req.(*GetRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRegistriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).List(ctx, req.(*ListRegistriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Create(ctx, req.(*CreateRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Update(ctx, req.(*UpdateRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Delete(ctx, req.(*DeleteRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/ListAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/SetAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/UpdateAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RegistryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.containerregistry.v1.RegistryService",
	HandlerType: (*RegistryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _RegistryService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _RegistryService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _RegistryService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _RegistryService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _RegistryService_Delete_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _RegistryService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _RegistryService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _RegistryService_UpdateAccessBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/containerregistry/v1/registry_service.proto",
}
