//
//  DarkRoomAssetResourceLoaderRequest.swift
//  
//
//  Created by Kiarash Vosough on 7/14/22.
//
//  Copyright (c) 2022 Divar
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in all
//  copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//  SOFTWARE.

import Foundation
import AVFoundation

/*
 Usage of AssetResourceLoading is suspended for now,
 but the abstraction and support for using it is stil retained.
 users can implement their own way of handling request by the API we provided
 */

// MARK: - Abstraction

/// abstraction for `AVAssetResourceLoadingRequest` componnent to process it in isolation and have full control of start responding to `AVAssetResourceLoadingRequest` or finish it.
public protocol DarkRoomAssetResourceLoaderRequest: AnyObject {
    
    var request: AVAssetResourceLoadingRequest { get }

    func prepareForRetry() throws
    
    func start()
    
    func cancel()
    
    func finish()
}

// MARK: - Delegate

public protocol DarkRoomVideoLoadingRequestDelegate: AnyObject {
    
    func videoRequest(
        _ request: DarkRoomAssetResourceLoaderRequest,
        didFinish loadingRequest: AVAssetResourceLoadingRequest,
        with error: Error?
    )
}
