/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.InvalidCommandLineOptionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ErrorProneOptions {
    private static final String IGNORE_UNKNOWN_CHECKS_FLAG = "-XepIgnoreUnknownCheckNames";
    private static final String FLAG_PREFIX = "-Xep:";
    private static final String DISABLE_WARNINGS_IN_GENERATED_CODE_FLAG = "-XepDisableWarningsInGeneratedCode";
    private final ImmutableList<String> remainingArgs;
    private final ImmutableMap<String, Severity> severityMap;
    private final boolean ignoreUnknownChecks;
    private final boolean disableWarningsInGeneratedCode;
    private static final ErrorProneOptions EMPTY = new Builder().build((ImmutableList<String>)ImmutableList.of());

    public static int isSupportedOption(String option) {
        boolean isSupported = option.startsWith(FLAG_PREFIX) || option.equals(IGNORE_UNKNOWN_CHECKS_FLAG) || option.equals(DISABLE_WARNINGS_IN_GENERATED_CODE_FLAG);
        return isSupported ? 0 : -1;
    }

    private ErrorProneOptions(ImmutableMap<String, Severity> severityMap, ImmutableList<String> remainingArgs, boolean ignoreUnknownChecks, boolean disableWarningsInGeneratedCode) {
        this.severityMap = severityMap;
        this.remainingArgs = remainingArgs;
        this.ignoreUnknownChecks = ignoreUnknownChecks;
        this.disableWarningsInGeneratedCode = disableWarningsInGeneratedCode;
    }

    public String[] getRemainingArgs() {
        return (String[])this.remainingArgs.toArray((Object[])new String[this.remainingArgs.size()]);
    }

    public ImmutableMap<String, Severity> getSeverityMap() {
        return this.severityMap;
    }

    public boolean ignoreUnknownChecks() {
        return this.ignoreUnknownChecks;
    }

    public boolean disableWarningsInGeneratedCode() {
        return this.disableWarningsInGeneratedCode;
    }

    public static ErrorProneOptions empty() {
        return EMPTY;
    }

    public static ErrorProneOptions processArgs(Iterable<String> args) throws InvalidCommandLineOptionException {
        Preconditions.checkNotNull(args);
        ImmutableList.Builder outputArgs = ImmutableList.builder();
        Builder builder = new Builder();
        for (String arg : args) {
            if (arg.equals(IGNORE_UNKNOWN_CHECKS_FLAG)) {
                builder.setIgnoreUnknownChecks(true);
                continue;
            }
            if (arg.equals(DISABLE_WARNINGS_IN_GENERATED_CODE_FLAG)) {
                builder.setDisableWarningsInGeneratedCode(true);
                continue;
            }
            if (arg.startsWith(FLAG_PREFIX)) {
                Severity severity;
                String remaining = arg.substring(FLAG_PREFIX.length());
                String[] parts = remaining.split(":");
                if (parts.length > 2 || parts[0].isEmpty()) {
                    throw new InvalidCommandLineOptionException("invalid flag: " + arg);
                }
                String checkName = parts[0];
                if (parts.length == 1) {
                    severity = Severity.DEFAULT;
                } else {
                    try {
                        severity = Severity.valueOf(parts[1]);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidCommandLineOptionException("invalid flag: " + arg);
                    }
                }
                builder.putSeverity(checkName, severity);
                continue;
            }
            outputArgs.add((Object)arg);
        }
        return builder.build((ImmutableList<String>)outputArgs.build());
    }

    public static ErrorProneOptions processArgs(String[] args) throws InvalidCommandLineOptionException {
        Preconditions.checkNotNull((Object)args);
        return ErrorProneOptions.processArgs(Arrays.asList(args));
    }

    private static class Builder {
        private boolean ignoreUnknownChecks = false;
        private boolean disableWarningsInGeneratedCode = false;
        private Map<String, Severity> severityMap = new HashMap<String, Severity>();

        private Builder() {
        }

        public void setIgnoreUnknownChecks(boolean ignoreUnknownChecks) {
            this.ignoreUnknownChecks = ignoreUnknownChecks;
        }

        public void setDisableWarningsInGeneratedCode(boolean disableWarningsInGeneratedCode) {
            this.disableWarningsInGeneratedCode = disableWarningsInGeneratedCode;
        }

        public void putSeverity(String checkName, Severity severity) {
            this.severityMap.put(checkName, severity);
        }

        public ErrorProneOptions build(ImmutableList<String> outputArgs) {
            return new ErrorProneOptions(ImmutableMap.copyOf(this.severityMap), outputArgs, this.ignoreUnknownChecks, this.disableWarningsInGeneratedCode);
        }
    }

    public static enum Severity {
        DEFAULT,
        OFF,
        WARN,
        ERROR;

    }
}

