/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CompileTimeConstant;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;

@BugPattern(name="NonFinalCompileTimeConstant", summary="@CompileTimeConstant parameters should be final", explanation="If a method's formal parameter is annotated with @CompileTimeConstant, the method will always be invoked with an argument that is a static constant. If the parameter itself is non-final, then it is a mutable reference to immutable data. This is rarely useful, and can be confusing when trying to use the parameter in a context that requires an compile-time constant. For example:\n\n    void f(@CompileTimeConstant y) {}\n    void g(@CompileTimeConstant x) {\n      f(x); // x is not a constant, did you mean to declare it as final?\n    }\n\n", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class NonFinalCompileTimeConstant
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        VariableTree firstTree = null;
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        for (VariableTree variableTree : tree.getParameters()) {
            Symbol.VarSymbol sym = ASTHelpers.getSymbol(variableTree);
            if (sym == null || !CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation(state, sym) || !this.maybeFix(fixBuilder, variableTree, sym) || firstTree != null) continue;
            firstTree = variableTree;
        }
        if (fixBuilder.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(firstTree, fixBuilder.build());
    }

    private boolean maybeFix(SuggestedFix.Builder fixBuilder, VariableTree parameter, Symbol.VarSymbol sym) {
        if (sym.getModifiers().contains((Object)Modifier.FINAL)) {
            return false;
        }
        for (AnnotationTree annotationTree : parameter.getModifiers().getAnnotations()) {
            Symbol annotationSym = ASTHelpers.getSymbol(annotationTree.getAnnotationType());
            if (annotationSym == null || !annotationSym.getSimpleName().toString().contentEquals(CompileTimeConstant.class.getSimpleName())) continue;
            fixBuilder.postfixWith(annotationTree, " final");
            return true;
        }
        return false;
    }
}

