/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@BugPattern(name="Overrides", altNames={"overrides"}, summary="Varargs doesn't agree for overridden method", explanation="A varargs method is overridden by a method with an array parameter, or vice versa.  Please match the signature of the method being overridden.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class Overrides
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(methodTree);
        boolean isVarargs = (methodSymbol.flags() & 0x400000000L) != 0L;
        Set<Symbol.MethodSymbol> superMethods = ASTHelpers.findSuperMethods(methodSymbol, state.getTypes());
        if (superMethods.isEmpty()) {
            return Description.NO_MATCH;
        }
        Iterator<Symbol.MethodSymbol> superMethodsIterator = superMethods.iterator();
        boolean areSupersVarargs = superMethodsIterator.next().isVarArgs();
        while (superMethodsIterator.hasNext()) {
            if (areSupersVarargs == superMethodsIterator.next().isVarArgs()) continue;
            return this.describeMatch(methodTree);
        }
        if (isVarargs == areSupersVarargs) {
            return Description.NO_MATCH;
        }
        List<? extends VariableTree> parameterTree = methodTree.getParameters();
        Tree paramType = parameterTree.get(parameterTree.size() - 1).getType();
        String paramTypeSource = state.getSourceForNode((JCTree)paramType);
        if (paramTypeSource == null) {
            return this.describeMatch(methodTree);
        }
        Description.Builder descriptionBuilder = this.buildDescription(methodTree);
        if (isVarargs) {
            descriptionBuilder.addFix(SuggestedFix.replace(paramType, "[]", paramTypeSource.length() - 3, 0));
        } else {
            int arrayOpenIndex = paramTypeSource.length() - 2;
            while (paramTypeSource.charAt(arrayOpenIndex) == ' ') {
                --arrayOpenIndex;
            }
            if (paramTypeSource.charAt(arrayOpenIndex) == '[') {
                descriptionBuilder.addFix(SuggestedFix.replace(paramType, "...", arrayOpenIndex, 0));
            }
        }
        return descriptionBuilder.build();
    }
}

