/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.EditDistance;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import javax.lang.model.element.Modifier;

@BugPattern(name="SelfAssignment", summary="Variable assigned to itself", explanation="The left-hand side and right-hand side of this assignment are the same. It has no effect.\n\nThis also handles assignments in which the right-hand side is a call to Preconditions.checkNotNull(), which returns the variable that was checked for non-nullity.  If you just intended to check that the variable is non-null, please don't assign the result to the checked variable; just call Preconditions.checkNotNull() as a bare statement.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class SelfAssignment
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher {
    @Override
    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        ExpressionTree expression = this.stripCheckNotNull(tree.getExpression(), state);
        if (ASTHelpers.sameVariable(tree.getVariable(), expression)) {
            return this.describeForAssignment(tree, state);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        ExpressionTree initializer = this.stripCheckNotNull(tree.getInitializer(), state);
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (initializer == null || initializer.getKind() != Tree.Kind.MEMBER_SELECT || parent.getKind() != Tree.Kind.CLASS || !tree.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            return Description.NO_MATCH;
        }
        MemberSelectTree rhs = (MemberSelectTree)initializer;
        Symbol rhsClass = ASTHelpers.getSymbol(rhs.getExpression());
        Symbol lhsClass = ASTHelpers.getSymbol(parent);
        if (rhsClass != null && lhsClass != null && rhsClass.equals(lhsClass) && rhs.getIdentifier().contentEquals(tree.getName())) {
            return this.describeForVarDecl(tree, state);
        }
        return Description.NO_MATCH;
    }

    private ExpressionTree stripCheckNotNull(ExpressionTree expression, VisitorState state) {
        if (expression != null && expression.getKind() == Tree.Kind.METHOD_INVOCATION && Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull").matches(expression, state)) {
            return ((MethodInvocationTree)expression).getArguments().get(0);
        }
        return expression;
    }

    public Description describeForVarDecl(VariableTree tree, VisitorState state) {
        String varDeclStr = tree.toString();
        int equalsIndex = varDeclStr.indexOf(61);
        if (equalsIndex < 0) {
            throw new IllegalStateException("Expected variable declaration to have an initializer: " + tree);
        }
        varDeclStr = varDeclStr.substring(0, equalsIndex - 1) + ";";
        return this.describeMatch(tree, SuggestedFix.replace(tree, varDeclStr));
    }

    public Description describeForAssignment(AssignmentTree assignmentTree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        Fix fix = SuggestedFix.delete(parent);
        ExpressionTree lhs = assignmentTree.getVariable();
        ExpressionTree rhs = assignmentTree.getExpression();
        if (assignmentTree.getExpression().getKind() == Tree.Kind.METHOD_INVOCATION) {
            fix = SuggestedFix.replace(assignmentTree, rhs.toString());
            rhs = this.stripCheckNotNull(rhs, state);
        }
        if (lhs.getKind() == Tree.Kind.MEMBER_SELECT) {
            TreePath path;
            assert (rhs.getKind() == Tree.Kind.IDENTIFIER || rhs.getKind() == Tree.Kind.MEMBER_SELECT);
            String rhsName = null;
            if (rhs.getKind() == Tree.Kind.IDENTIFIER) {
                rhsName = ((JCTree.JCIdent)rhs).name.toString();
            } else if (rhs.getKind() == Tree.Kind.MEMBER_SELECT) {
                rhsName = ((JCTree.JCFieldAccess)rhs).name.toString();
            }
            Type type = ((JCTree.JCFieldAccess)lhs).type;
            for (path = state.getPath(); path != null && path.getLeaf().getKind() != Tree.Kind.METHOD; path = path.getParentPath()) {
            }
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)path.getLeaf();
            int minEditDistance = Integer.MAX_VALUE;
            String replacement = null;
            for (JCTree.JCVariableDecl var : method.params) {
                int editDistance;
                if (var.type != type || (editDistance = EditDistance.getEditDistance(rhsName, var.name.toString())) >= minEditDistance) continue;
                minEditDistance = editDistance;
                replacement = var.name.toString();
            }
            if (replacement != null) {
                fix = SuggestedFix.replace(rhs, replacement);
            }
        } else if (rhs.getKind() == Tree.Kind.IDENTIFIER) {
            TreePath path;
            assert (lhs.getKind() == Tree.Kind.IDENTIFIER);
            String lhsName = ((JCTree.JCIdent)rhs).name.toString();
            Type type = ((JCTree.JCIdent)lhs).type;
            for (path = state.getPath(); path != null && !(path.getLeaf() instanceof JCTree.JCClassDecl); path = path.getParentPath()) {
            }
            if (path == null) {
                throw new IllegalStateException("Expected to find an enclosing class declaration");
            }
            JCTree.JCClassDecl klass = (JCTree.JCClassDecl)path.getLeaf();
            int minEditDistance = Integer.MAX_VALUE;
            String replacement = null;
            for (JCTree member : klass.getMembers()) {
                int editDistance;
                if (member.getKind() != Tree.Kind.VARIABLE) continue;
                JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)member;
                if (Flags.isStatic(var.sym) || var.type != type || (editDistance = EditDistance.getEditDistance(lhsName, var.name.toString())) >= minEditDistance) continue;
                minEditDistance = editDistance;
                replacement = var.name.toString();
            }
            if (replacement != null) {
                fix = SuggestedFix.replace(lhs, "this." + replacement);
            }
        }
        return this.describeMatch(assignmentTree, fix);
    }
}

