/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.common.base.Predicate;
import com.google.errorprone.dataflow.DataFlow;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessPropagationTransfer;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Context;
import java.io.Serializable;
import java.util.List;

public final class NullnessAnalysis
implements Serializable {
    private final NullnessPropagationTransfer nullnessPropagation;

    public NullnessAnalysis() {
        this.nullnessPropagation = new NullnessPropagationTransfer();
    }

    public NullnessAnalysis(Predicate<MethodInfo> additionalNonNullReturningMethods) {
        this.nullnessPropagation = new NullnessPropagationTransfer(additionalNonNullReturningMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Nullness getNullness(TreePath exprPath, Context context) {
        try {
            this.nullnessPropagation.setContext(context).setCompilationUnit(exprPath.getCompilationUnit());
            Nullness nullness = (Nullness)((Object)DataFlow.expressionDataflow(exprPath, context, this.nullnessPropagation));
            return nullness;
        }
        finally {
            this.nullnessPropagation.setContext(null).setCompilationUnit(null);
        }
    }

    public static interface MethodInfo {
        public String clazz();

        public String method();

        public List<String> annotations();

        public boolean isStatic();

        public boolean isPrimitive();
    }
}

