/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.List;

public class NextStatement<T extends StatementTree>
implements Matcher<T> {
    private Matcher<StatementTree> matcher;

    public NextStatement(Matcher<StatementTree> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(T stmt, VisitorState state) {
        TreePath path = state.getPath();
        Tree prev = null;
        Tree curr = path.getLeaf();
        boolean found = false;
        while (path != null) {
            prev = curr;
            curr = (path = path.getParentPath()).getLeaf();
            if (curr.getKind() != Tree.Kind.BLOCK) continue;
            found = true;
            break;
        }
        assert (found);
        BlockTree block = (BlockTree)curr;
        List<? extends StatementTree> stmts = block.getStatements();
        int ifStmtIdx = stmts.indexOf(prev);
        StatementTree nextStmt = null;
        if (ifStmtIdx < stmts.size() - 1) {
            nextStmt = stmts.get(ifStmtIdx + 1);
        }
        return this.matcher.matches(nextStmt, state);
    }
}

