---
layout: community
title: Bazel Users
---

# Corporate users of Bazel

## [Braintree](https://www.braintreepayments.com)

Braintree, a PayPal subsidiary, develops payment solutions for websites and
applications. They use Bazel for parts of their internal build and Paul Gross
even posted a [nice piece about how their switch to
Bazel went](https://www.pgrs.net/2015/09/01/migrating-from-gradle-to-bazel/).

## [Makani](https://www.google.com/makani)

Makani, now a Google subsidiary, develops energy kites and uses
Bazel to build their software (including their embedded C++ software).

# Open-source projects using Bazel

If you'd like your project listed here, please
[let us know](mailto:kchodorow@google.com?subject=My project uses Bazel)!

## [CallBuilder](https://github.com/google/CallBuilder)

A Java code generator that allows you to create a builder by writing one
function.

## [Error Prone](https://github.com/google/error-prone)

Catches common Java mistakes as compile-time errors. (Migration to Bazel is
in progress.)

## [GRPC](http://www.grpc.io)

A language-and-platform-neutral remote procedure call system. (Bazel is a
supported, although not primary, build system.)

## [Jsonnet](http://google.github.io/jsonnet/doc/)

An elegant, formally-specified config generation language for JSON. (Bazel is a
supported build system.)

## [Kythe](https://github.com/google/kythe)

An ecosystem for building tools that work with code.

## [PetitParser for Java](https://github.com/petitparser/java-petitparser)

Grammars for programming languages are traditionally specified statically. They
are hard to compose and reuse due to ambiguities that inevitably arise.
PetitParser combines ideas from scannnerless parsing, parser combinators,
parsing expression grammars and packrat parsers to model grammars and parsers
as objects that can be reconfigured dynamically.

## [TensorFlow](http://tensorflow.org)

An open source software library for machine intelligence.

## [Trunk](https://github.com/mzhaom/trunk)

A collection of C++/Java opensource projects with BUILD files so they
can be built with Bazel with out of box support for protobuf and
grpc (maybe thrift).

## [Turbo Santa](https://github.com/turbo-santa/turbo-santa-common)

A platform-independent GameBoy emulator.
