<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:db="http://docbook.org/ns/docbook"
                xmlns:xi="http://www.w3.org/2001/XInclude"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:x="http://docbook.org/ns/docbook/not-xslt"
                xmlns:h="http://www.w3.org/1999/xhtml"
                xmlns="http://www.w3.org/1999/xhtml"
                exclude-result-prefixes="#all"
                version="3.0">

<xsl:output method="xml" encoding="utf-8" indent="yes"/>

<xsl:namespace-alias stylesheet-prefix="x" result-prefix="xsl"/>

<xsl:template match="/" name="xsl:initial-template">
  <x:stylesheet default-mode="m:docbook"
                exclude-result-prefixes="#all"
                version="3.0">
    <xsl:namespace name="xsl" select="'http://www.w3.org/1999/XSL/Transform'"/>
    <xsl:namespace name="db" select="'http://docbook.org/ns/docbook'"/>
    <xsl:namespace name="ext" select="'http://docbook.org/extensions/xslt'"/>
    <xsl:namespace name="f" select="'http://docbook.org/ns/docbook/functions'"/>
    <xsl:namespace name="m" select="'http://docbook.org/ns/docbook/modes'"/>
    <xsl:namespace name="v" select="'http://docbook.org/ns/docbook/variables'"/>
    <xsl:namespace name="vp" select="'http://docbook.org/ns/docbook/variables/private'"/>
    <xsl:namespace name="xs" select="'http://www.w3.org/2001/XMLSchema'"/>
    <xsl:namespace name="" select="'http://www.w3.org/1999/xhtml'"/>

    <xsl:text>&#10;&#10;</xsl:text>
    <xsl:comment> **********************************************************************
     This file is generated automatically from the parameters
     reference in the guide. Do not edit this file by hand.
     ********************************************************************** </xsl:comment>

    <xsl:text>&#10;&#10;</xsl:text>
    <xsl:comment> Note: Some of these parameters are initialized using content
     instead of a select attribute in order to make the reference page
     in the Guide work better. </xsl:comment>

    <xsl:text>&#10;&#10;</xsl:text>
    <xsl:comment> Many of these parameters are shadowed by variables (see
     variable.xsl) for use in the stylesheets. Often, they're defined
     as strings here and as more useful data types in the variables. </xsl:comment>

    <xsl:text>&#10;&#10;</xsl:text>

    <xsl:variable name="variables"
                  select="//db:fieldsynopsis
                          [not(ancestor::db:refentry[contains-token(@role, 'obsolete')])]"/>

    <xsl:apply-templates select="$variables"/>

    <x:variable name="vp:static-parameters" as="map(xs:QName, item()*)">
      <x:map>
        <xsl:for-each select="$variables[db:modifier[. = 'static']]">
          <x:map-entry key="QName('', '{db:varname}')" select="${db:varname}"/>
        </xsl:for-each>
      </x:map>
    </x:variable>
    <x:variable name="vp:dynamic-parameters" as="map(xs:QName, item()*)">
      <x:map>
        <xsl:for-each select="$variables[not(db:modifier[. = 'static'])]">
          <x:map-entry key="QName('', '{db:varname}')" select="${db:varname}"/>
        </xsl:for-each>
      </x:map>
    </x:variable>
  </x:stylesheet>
</xsl:template>

<xsl:template match="db:fieldsynopsis">
  <x:param name="{db:varname}">
    <xsl:if test="db:modifier[. = 'static']">
      <xsl:attribute name="static" select="'yes'"/>
    </xsl:if>
    <xsl:if test="db:type">
      <xsl:attribute name="as" select="db:type/string()"/>
    </xsl:if>
    <xsl:apply-templates select="db:initializer"/>
  </x:param>
</xsl:template>

<xsl:template match="db:initializer">
  <xsl:choose>
    <xsl:when test="*">
      <xsl:apply-templates mode="copy-without-namespaces"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:attribute name="select" select="string(.)"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:mode name="copy-without-namespaces" on-no-match="shallow-copy"/>

<xsl:template match="h:*" mode="copy-without-namespaces" priority="10">
  <xsl:element name="{local-name(.)}" namespace="http://www.w3.org/1999/xhtml">
    <xsl:apply-templates select="@*,node()" mode="copy-without-namespaces"/>
  </xsl:element>
</xsl:template>

<xsl:template match="xsl:*" mode="copy-without-namespaces" priority="10">
  <xsl:element name="xsl:{local-name(.)}" namespace="http://www.w3.org/1999/XSL/Transform">
    <xsl:apply-templates select="@*,node()" mode="copy-without-namespaces"/>
  </xsl:element>
</xsl:template>

<xsl:template match="*" mode="copy-without-namespaces">
  <xsl:message terminate="yes">Unexpected element: <xsl:sequence select="node-name(.)"/></xsl:message>
</xsl:template>

</xsl:stylesheet>
