The following table describes the feature list for .NET Core debugging using VS Code C# extension / VS For Mac / [Visual Studio](https://github.com/microsoft/MIEngine/wiki/Offroad-Debugging-of-.NET-Core-on-Linux---OSX-from-Visual-Studio) on non-Windows platforms with availability information:

| Feature   | Description | Visual Studio Code | Visual Studio For Mac | Visual Studio |  Availability |
| --------- | ----------- | :----------------: | :-------------------: | :-----------: | ------------- |
| Breakpoints | Adding / removing breakpoints | :white_check_mark: | :white_check_mark: | :white_check_mark: | VS2015.3 + [MIEngine](https://github.com/Microsoft/MIEngine/wiki/Building-the-MIEngine) / C# ext 1.2.2 / VS For Mac Preview |
| Execution control | Step through code (including async stepping), pause, continue | :white_check_mark: | :white_check_mark: | :white_check_mark: | VS2015.3 + [MIEngine](https://github.com/Microsoft/MIEngine/wiki/Building-the-MIEngine) / C# ext 1.2.2 / VS For Mac Preview|
| Launch / Attach | Includes launching, attaching to, detaching from and terminating the target app | :white_check_mark: | :white_check_mark: | :white_check_mark: | VS2015.3 + [MIEngine](https://github.com/Microsoft/MIEngine/wiki/Building-the-MIEngine) / C# ext 1.2.2 / VS For Mac Preview|
| EE | This is the ability to view variables, custom expressions in locals / watch windows | :white_check_mark: | :white_check_mark: | :white_check_mark: | VS2015.3 + [MIEngine](https://github.com/Microsoft/MIEngine/wiki/Building-the-MIEngine) / C# ext 1.2.2 / VS For Mac Preview|
| Just my code | This is the ability to hide external code during debugging | :white_check_mark: | :white_check_mark: | :white_check_mark: | VS2015.3 + [MIEngine](https://github.com/Microsoft/MIEngine/wiki/Building-the-MIEngine) / C# ext 1.2.2 / VS For Mac Preview|
| Conditional breakpoints | This is the ability to stop on a breakpoint when the given condition is satisfied | :white_check_mark: | :white_check_mark: | :white_check_mark: | VS2015.3 + [MIEngine](https://github.com/Microsoft/MIEngine/wiki/Building-the-MIEngine) / C# ext 1.3.0 / VS For Mac Preview|
| Debugging Razor views | This is the ability to debug embedded code in cshtml files | :white_check_mark: | :white_check_mark: | N/A | VS2015.3 + [MIEngine](https://github.com/Microsoft/MIEngine/wiki/Building-the-MIEngine) / C# ext 1.3.0 |
| Edit variable values | This is the ability to update the value of a variable inside locals / watch windows | :white_check_mark: | :white_check_mark: | :white_check_mark: | VS2015.3 + [MIEngine](https://github.com/Microsoft/MIEngine/wiki/Building-the-MIEngine) / C# ext 1.3.0 / VS For Mac Preview|
| Set Next Statement | This is the ability to change the current instruction pointer to another line during debugging | [Work Item](https://github.com/Microsoft/vscode-debugadapter-node/issues/28) | [Work Item](https://github.com/Microsoft/vscode-debugadapter-node/issues/28) | [Work Item](https://github.com/Microsoft/vscode-debugadapter-node/issues/28) | |
| Tracepoints | This is the ability to print custom expressions when a breakpoint is hit | N/A | | | |
| Symbol search information | Showing the path to the pdb being loaded for a particular module | | | | |
| Symbol Server | This is the ability to specify a remote server to pull down pdbs for code being debugged | [Work Item](https://github.com/dotnet/roslyn/issues/6881) | [Work Item](https://github.com/dotnet/roslyn/issues/6881) | [Work Item](https://github.com/dotnet/roslyn/issues/6881) |
| Source Server | This is the ability to pull down sources from a remote server for code being debugged | [Work Item](https://github.com/dotnet/roslyn/issues/5397) [Work Item](https://github.com/dotnet/roslyn/issues/4119)| [Work Item](https://github.com/dotnet/roslyn/issues/5397) [Work Item](https://github.com/dotnet/roslyn/issues/4119) | [Work Item](https://github.com/dotnet/roslyn/issues/5397) [Work Item](https://github.com/dotnet/roslyn/issues/4119) | |
| Manual symbol loading | This is the ability to locate and load symbols for a module anytime during a debug session | | | | |
| Function bps | This is the ability to stop the debugger at the start of a given function | [Work Item](https://github.com/dotnet/vscode-csharp/issues/295)| [Work Item](https://github.com/dotnet/vscode-csharp/issues/295) | [Work Item](https://github.com/dotnet/vscode-csharp/issues/295) |
| Hit count bps | This is the ability to stop the debugger after a breakpoint is hit given number of times | [Work Item](https://github.com/dotnet/vscode-csharp/issues/895)| [Work Item](https://github.com/dotnet/vscode-csharp/issues/895) | [Work Item](https://github.com/dotnet/vscode-csharp/issues/895) |
| Edit and Continue | This is the ability to make code changes during a debugging session without having to restart a new session | [Work Item](https://github.com/dotnet/roslyn/issues/1952) | [Work Item](https://github.com/dotnet/roslyn/issues/1952) | [Work Item](https://github.com/dotnet/roslyn/issues/1952) |
| Dump debugging | This is the ability to debug crash dumps | | | | |
| Return values | This is the ability to see the values a function returns as the user is stepping through the code | | | | |
| Visualizers | This is the ability to invoke a custom UI for visualizing a value in the locals / watch windows | | | | |
| Step Into Specific | This is the ability to select a particular function to step into when the current instruction pointer is on a line that contains multiple functions to be called | | | |
