# Overview
The C# extension needs to be signed with MSFT signatures in order to be uploaded to the marketplace.

Server side components should be signed when those artifacts are generated (e.g. Roslyn build signs Roslyn artifacts).  However we also need to sign the artifacts we generate in the extension-
1.  The extension JS code.
2.  The VSIX's we produce
3.  For MSFT publishing, we must also generate a signed manifest.

Official builds are responsible for signing.  We only real sign builds from the `prerelease` or `release` branches, everything else is test signed.

## Signing Steps

### Signing JS
As part of packaging, the extension TS/JS code is compiled/minified into the `dist/` folder which gets distributed inside the VSIX.  The contents of `dist/` are generated by the `vscode:prepublish` NPM target, which is run by `vsce` during packaging.

After the JS code is generated, but before it gets packaged we need to sign it.  This is handled by running the `gulp signJs` target as a part of `vscode:prepublish`.  Internally the gulp task delegates to the `signJs/signJs.proj` project to configure what and how to sign using MicroBuild.

### Signing VSIX
Once we've generated the VSIX with the signed JS contents, we also need to sign the VSIX.  VSIX signing for VSCode is a bit different from VS.  Instead of submitting the VSIX itself to be signed, we submit a copy of the manifest file to the signing service.

To do this, as the last step of VSIX packaging (in `gulp vsix:release:package`) we call out to `vsce generate-manifest` to generate the manifest file for each VSIX.  Once the task is finished, every `<name>.vsix` will be paired with a `<name>.manifest` file inside the `vsix/` folder.

The next step is to copy the manifest file to a `<name>.signature.p7s` file which gets submitted to the signing service (and replaced with the signed version).  The `signVsix.proj` (invoked via the `gulp signVsix` task) copies and transforms the manifest file and submits it to the signing service.

Finally, when we actually publish the extension, we must pass upload the vsix, manifest file, and signed signature file to `vsce`.

# Running test signing locally
To test various signing workflows, you may need to run signing locally.

1.  Run `gulp installSignPlugin` - this will install the MicroBuild signing plugin to your global nuget packages directory.  This is required to make the signing targets on the various signing projects actually run.  In CI, this is installed via a pipeline step.
2.  To test JS signing, run `npm run vscode:prepublish` (or the `gulp signJs` task to skip generation of `dist/`).  You can verify the JS is signed by checking for the 'Digital Signatures' tab on the file properties in Windows.  The binlog, in `out/logs/signJs.binlog` will have details on the signing that took place.  If you do not see a 'Sign' target running, then signing did not run.
3.  To test VSIX signing, first generate the VSIX's as normal.  Then run the `gulp signVsix` target.  If signing ran successfully, the VSIX's should be updated in-place and have a `package/services/digital-signature` folder inside of them.  For more details on the signing, see the `out/logs/signVsix.binlog`.