/*
 * Copyright 2018 LINE Corporation
 *
 * LINE Corporation licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

import Paper from '@material-ui/core/Paper';
import { createStyles, makeStyles, Theme } from '@material-ui/core/styles';
import React, { ReactNode } from 'react';

const useStyles = makeStyles((theme: Theme) =>
  createStyles({
    section: {
      padding: theme.spacing(3),
      marginBottom: theme.spacing(1),
      marginTop: theme.spacing(1),
    },
  }),
);

const Section: React.FunctionComponent<{ children?: ReactNode }> = ({
  children,
}) => {
  const classes = useStyles();
  return <Paper className={classes.section}>{children}</Paper>;
};

export default React.memo(Section);
