package doobie.enum

import doobie.util.invariant._

import java.sql.Statement._

#+scalaz
import scalaz.Equal
import scalaz.std.anyVal.intInstance
#-scalaz
#+cats
import cats.kernel.Eq
import cats.kernel.instances.int._
#-cats

object autogeneratedkeys {

  /** @group Implementation */
  sealed abstract class AutoGeneratedKeys(val toInt: Int)

  /** @group Values */ case object ReturnGeneratedKeys extends AutoGeneratedKeys(RETURN_GENERATED_KEYS)
  /** @group Values */ case object NoGeneratedKeys extends AutoGeneratedKeys(NO_GENERATED_KEYS)

  /** @group Implementation */
  object AutoGeneratedKeys {

    def fromInt(n: Int): Option[AutoGeneratedKeys] =
      Some(n) collect {
        case ReturnGeneratedKeys.toInt => ReturnGeneratedKeys
        case NoGeneratedKeys.toInt => NoGeneratedKeys
      }

    def unsafeFromInt(n: Int): AutoGeneratedKeys =
      fromInt(n).getOrElse(throw InvalidOrdinal[AutoGeneratedKeys](n))

#+scalaz
    implicit val EqualAutoGeneratedKeys: Equal[AutoGeneratedKeys] =
      Equal.equalBy(_.toInt)
#-scalaz
#+cats
    implicit val EqAutoGeneratedKeys: Eq[AutoGeneratedKeys] =
      Eq.by(_.toInt)
#-cats

  }

}
