// This file is @generated by prost-build.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RunAgentRequest {
    #[prost(string, tag = "1")]
    pub prompt: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub session_id: ::prost::alloc::string::String,
    /// control flag to distinguish frontend requests
    #[prost(bool, tag = "3")]
    pub is_chat_request: bool,
    #[prost(string, optional, tag = "4")]
    pub request_api_key: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(string, optional, tag = "5")]
    pub cdp_url: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(string, optional, tag = "6")]
    pub parent_span_context: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(enumeration = "ModelProvider", optional, tag = "7")]
    pub model_provider: ::core::option::Option<i32>,
    #[prost(string, optional, tag = "8")]
    pub model: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(bool, optional, tag = "9")]
    pub enable_thinking: ::core::option::Option<bool>,
    #[prost(bool, optional, tag = "10")]
    pub return_screenshots: ::core::option::Option<bool>,
    #[prost(bool, optional, tag = "11")]
    pub return_agent_state: ::core::option::Option<bool>,
    #[prost(bool, optional, tag = "12")]
    pub return_storage_state: ::core::option::Option<bool>,
    #[prost(string, optional, tag = "13")]
    pub storage_state: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(string, optional, tag = "14")]
    pub agent_state: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(uint64, optional, tag = "15")]
    pub timeout: ::core::option::Option<u64>,
    #[prost(uint64, optional, tag = "16")]
    pub max_steps: ::core::option::Option<u64>,
    #[prost(uint64, optional, tag = "17")]
    pub thinking_token_budget: ::core::option::Option<u64>,
    #[prost(string, optional, tag = "18")]
    pub start_url: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ActionResult {
    #[prost(bool, optional, tag = "1")]
    pub is_done: ::core::option::Option<bool>,
    #[prost(string, optional, tag = "2")]
    pub content: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(string, optional, tag = "3")]
    pub error: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(bool, optional, tag = "4")]
    pub give_control: ::core::option::Option<bool>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StepChunkContent {
    #[prost(message, optional, tag = "1")]
    pub action_result: ::core::option::Option<ActionResult>,
    #[prost(string, tag = "2")]
    pub summary: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub trace_id: ::prost::alloc::string::String,
    #[prost(string, optional, tag = "4")]
    pub screenshot: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AgentOutput {
    #[prost(message, optional, tag = "1")]
    pub result: ::core::option::Option<ActionResult>,
    #[prost(string, optional, tag = "2")]
    pub trace_id: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(uint64, optional, tag = "3")]
    pub step_count: ::core::option::Option<u64>,
    #[prost(string, optional, tag = "4")]
    pub storage_state: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(string, optional, tag = "5")]
    pub agent_state: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ErrorChunkContent {
    #[prost(string, tag = "1")]
    pub content: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RunAgentResponseStreamChunk {
    #[prost(oneof = "run_agent_response_stream_chunk::ChunkType", tags = "1, 2, 3, 4")]
    pub chunk_type: ::core::option::Option<run_agent_response_stream_chunk::ChunkType>,
}
/// Nested message and enum types in `RunAgentResponseStreamChunk`.
pub mod run_agent_response_stream_chunk {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ChunkType {
        #[prost(message, tag = "1")]
        StepChunkContent(super::StepChunkContent),
        #[prost(message, tag = "2")]
        AgentOutput(super::AgentOutput),
        #[prost(message, tag = "3")]
        ErrorChunkContent(super::ErrorChunkContent),
        #[prost(message, tag = "4")]
        TimeoutChunkContent(super::StepChunkContent),
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum ModelProvider {
    Anthropic = 0,
    Bedrock = 1,
    Openai = 2,
    Gemini = 3,
}
impl ModelProvider {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Anthropic => "ANTHROPIC",
            Self::Bedrock => "BEDROCK",
            Self::Openai => "OPENAI",
            Self::Gemini => "GEMINI",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "ANTHROPIC" => Some(Self::Anthropic),
            "BEDROCK" => Some(Self::Bedrock),
            "OPENAI" => Some(Self::Openai),
            "GEMINI" => Some(Self::Gemini),
            _ => None,
        }
    }
}
/// Generated client implementations.
pub mod agent_manager_service_client {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    #[derive(Debug, Clone)]
    pub struct AgentManagerServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl AgentManagerServiceClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> AgentManagerServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::Body>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + std::marker::Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + std::marker::Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> AgentManagerServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::Body>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::Body>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::Body>,
            >>::Error: Into<StdError> + std::marker::Send + std::marker::Sync,
        {
            AgentManagerServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        pub async fn run_agent(
            &mut self,
            request: impl tonic::IntoRequest<super::RunAgentRequest>,
        ) -> std::result::Result<tonic::Response<super::AgentOutput>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/agent_manager_grpc.AgentManagerService/RunAgent",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("agent_manager_grpc.AgentManagerService", "RunAgent"),
                );
            self.inner.unary(req, path, codec).await
        }
        pub async fn run_agent_stream(
            &mut self,
            request: impl tonic::IntoRequest<super::RunAgentRequest>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::RunAgentResponseStreamChunk>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/agent_manager_grpc.AgentManagerService/RunAgentStream",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "agent_manager_grpc.AgentManagerService",
                        "RunAgentStream",
                    ),
                );
            self.inner.server_streaming(req, path, codec).await
        }
    }
}
