export default function CookiesPage() {
  return (
    <div className="max-w-4xl mx-auto p-6 space-y-4">
      <div>
        <div><strong>
          <h1>COOKIE POLICY</h1>
        </strong></div>
        <div><span><strong><span>Last updated August 19, 2025 </span></strong></span></div>
        <div><span>This Cookie Policy explains how LMNR AI, Inc. (DBA Laminar) ("<strong>Company</strong>," "<strong>we</strong>," "<strong>us</strong>," and "<strong>our</strong>") uses cookies and similar technologies to recognize you when you visit our website at </span>
          <a href="https://laminar.sh" target="_blank">https://laminar.sh</a>
          <span> ("<strong>Website</strong>"). It explains what these technologies are and why we use them, as well as your rights to control our use of them.</span></div>
        <span>In some cases we may use cookies to collect personal information, or that becomes personal information if we combine it with other information.</span>
        <div><span><strong>
          <h2>What are cookies?</h2>
        </strong></span></div>
        <span>Cookies are small data files that are placed on your computer or mobile device when you visit a website. Cookies are widely used by website owners in order to make their websites work, or to work more efficiently, as well as to provide reporting information.</span>
        <span>Cookies set by the website owner (in this case, LMNR AI, Inc. (DBA Laminar)) are called "first-party cookies." Cookies set by parties other than the website owner are called "third-party cookies." Third-party cookies enable third-party features or functionality to be provided on or through the website (e.g., advertising, interactive content, and analytics). The parties that set these third-party cookies can recognize your computer both when it visits the website in question and also when it visits certain other websites.</span>
        <div><span><strong>
          <h2>Why do we use cookies?</h2>
        </strong></span></div>
        <span>We use first- and third-party cookies for several reasons. Some cookies are required for technical reasons in order for our Website to operate, and we refer to these as "essential" or "strictly necessary" cookies. Other cookies also enable us to track and target the interests of our users to enhance the experience on our Online Properties. Third parties serve cookies through our Website for advertising, analytics, and other purposes. This is described in more detail below.</span>
        <div><span id="control"><strong>
          <h2>How can I control cookies?</h2>
        </strong></span></div>
        <span>You have the right to decide whether to accept or reject cookies. You can exercise your cookie rights by setting your preferences in the Cookie Consent Manager. The Cookie Consent Manager allows you to select which categories of cookies you accept or reject. Essential cookies cannot be rejected as they are strictly necessary to provide you with services.</span>
        <span>The Cookie Consent Manager can be found in the notification banner and on our Website. If you choose to reject cookies, you may still use our Website though your access to some functionality and areas of our Website may be restricted. You may also set or amend your web browser controls to accept or refuse cookies.</span>
        <div><span>The specific types of first- and third-party cookies served through our Website and the purposes they perform are described in the table below (please note that the specific </span><span>cookies served may vary depending on the specific Online Properties you visit):</span><span><strong><u><br />
          <h3>Essential website cookies:</h3>
        </u></strong></span><span>These cookies are strictly necessary to provide you with services available through our Website and to use some of its features, such as access to secure areas.</span></div>
        <div>
          <section>
            <div>
              <table>
                <tbody>
                  <tr>
                    <th>Name: </th>
                    <td><span>__Host-next-auth.csrf-token</span>
                    </td>
                  </tr>
                  <tr>
                    <th> Purpose:</th>
                    <td><span>Authentication</span></td>
                  </tr>
                  <tr>
                    <th> Provider:</th>
                    <td><span>LMNR AI, Inc. (DBA Laminar)</span></td>
                  </tr>
                  <tr>
                    <th>Type: </th>
                    <td><span>http_cookie</span></td>
                  </tr>
                  <tr>
                    <th>Expires in:</th>
                    <td><span>30 days</span></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </section>
          <section>
            <div>
              <table>
                <tbody>
                  <tr>
                    <th>Name: </th>
                    <td><span>evaluation-trace-view-width</span>
                    </td>
                  </tr>
                  <tr>
                    <th> Purpose:</th>
                    <td><span>Store viewing functionality</span>
                    </td>
                  </tr>
                  <tr>
                    <th> Provider:</th>
                    <td><span>LMNR AI, Inc. (DBA Laminar)</span></td>
                  </tr>
                  <tr>
                    <th>Type: </th>
                    <td><span>http_cookie</span></td>
                  </tr>
                  <tr>
                    <th>Expires in:</th>
                    <td><span>30 days</span></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </section>
          <section>
            <div>
              <table>
                <tbody>
                  <tr>
                    <th>Name: </th>
                    <td><span>traces-trace-view-width</span></td>
                  </tr>
                  <tr>
                    <th> Purpose:</th>
                    <td><span>Store view configuration</span></td>
                  </tr>
                  <tr>
                    <th> Provider:</th>
                    <td><span>LMNR AI, Inc. (DBA Laminar)</span></td>
                  </tr>
                  <tr>
                    <th>Type: </th>
                    <td><span>http_cookie</span></td>
                  </tr>
                  <tr>
                    <th>Expires in:</th>
                    <td><span>30 days</span></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </section>
          <section>
            <div>
              <table>
                <tbody>
                  <tr>
                    <th>Name: </th>
                    <td><span>__Secure-next-auth.session-token</span>
                    </td>
                  </tr>
                  <tr>
                    <th> Purpose:</th>
                    <td><span>Authentication</span></td>
                  </tr>
                  <tr>
                    <th> Provider:</th>
                    <td><span>LMNR AI, Inc. (DBA Laminar)</span></td>
                  </tr>
                  <tr>
                    <th>Type: </th>
                    <td><span>http_cookie</span></td>
                  </tr>
                  <tr>
                    <th>Expires in:</th>
                    <td><span>30 days</span></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </section><span><strong><u><br />
            <h3>Analytics and customization cookies:</h3>
          </u></strong></span><span>These cookies collect information that is used either in aggregate form to help us understand how our Website is being used or how effective our marketing campaigns are, or to help us customize our Website for you.</span>
        </div>
        <div><span>
          <section>
            <div>
              <table>
                <tbody>
                  <tr>
                    <th> Name:</th>
                    <td><span>ph_phc_*_posthog</span></td>
                  </tr>
                  <tr>
                    <th> Purpose:</th>
                    <td><span>Usage analytics</span></td>
                  </tr>
                  <tr>
                    <th> Provider:</th>
                    <td><span>PostHog</span></td>
                  </tr>
                  <tr>
                    <th> Type:</th>
                    <td><span>http_cookie</span></td>
                  </tr>
                  <tr>
                    <th> Expires in:</th>
                    <td><span>1 year</span></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </section>
        </span></div>
        <div><span><strong>
          <h2>How can I control cookies on my browser?</h2>
        </strong></span></div>
        <span>As the means by which you can refuse cookies through your web browser controls vary from browser to browser, you should visit your browser's help menu for more information. The following is information about how to manage cookies on the most popular browsers:</span>
        <ul>
          <li><span><a href="https://support.google.com/chrome/answer/95647#zippy=%2Callow-or-block-cookies" target="_blank"><span>Chrome</span></a></span>
          </li>
          <li><span><a href="https://support.microsoft.com/en-us/windows/delete-and-manage-cookies-168dab11-0753-043d-7c16-ede5947fc64d" target="_blank"><span>Internet Explorer</span></a></span></li>
          <li><span><a href="https://support.mozilla.org/en-US/kb/enhanced-tracking-protection-firefox-desktop?redirectslug=enable-and-disable-cookies-website-preferences&amp;redirectlocale=en-US" target="_blank"><span>Firefox</span></a></span>
          </li>
          <li><span><a href="https://support.apple.com/en-ie/guide/safari/sfri11471/mac" target="_blank"><span>Safari</span></a></span></li>
          <li><span><a href="https://support.microsoft.com/en-us/windows/microsoft-edge-browsing-data-and-privacy-bb8174ba-9d73-dcf2-9b4a-c582b4e640dd" target="_blank"><span>Edge</span></a></span></li>
          <li><span><a href="https://help.opera.com/en/latest/web-preferences/" target="_blank"><span>Opera</span></a></span></li>
        </ul>
        <span>In addition, most advertising networks offer you a way to opt out of targeted advertising. If you would like to find out more information, please visit:</span>
        <ul>
          <li><span><a href="http://www.aboutads.info/choices/" target="_blank"><span>Digital Advertising Alliance</span></a></span></li>
          <li><span><a href="https://youradchoices.ca/" target="_blank"><span>Digital Advertising Alliance of Canada</span></a></span></li>
          <li><span><a href="http://www.youronlinechoices.com/" target="_blank"><span>European Interactive Digital Advertising Alliance</span></a></span>
          </li>
        </ul>
        <div><strong>
          <h2>What about other tracking technologies, like web beacons?</h2>
        </strong></div>
        <span>Cookies are not the only way to recognize or track visitors to a website. We may use other, similar technologies from time to time, like web beacons (sometimes called "tracking pixels" or "clear gifs"). These are tiny graphics files that contain a unique identifier that enables us to recognize when someone has visited our Website or opened an email including them. This allows us, for example, to monitor </span><span>the traffic patterns of users from one page within a website to another, to deliver or communicate with cookies, to understand whether you have come to the website from an online advertisement displayed on a third-party website, to improve site performance, and to measure the success of email marketing campaigns. In many instances, these technologies are reliant on cookies to function properly, and so declining cookies will impair their functioning.</span>
        <div><span><strong>
          <h2>Do you use Flash cookies or Local Shared Objects?</h2>
        </strong></span></div>
        <span>Websites may also use so-called "Flash Cookies" (also known as Local Shared Objects or "LSOs") to, among other things, collect and store information about your use of our services, fraud prevention, and for other site operations.</span>
        <div><span>If you do not want Flash Cookies stored on your computer, you can adjust the settings of your Flash player to block Flash Cookies storage using the tools contained in the </span><span><a href="http://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager07.html" target="_blank"><span>Website Storage Settings Panel</span></a><span>. You can also control Flash Cookies by going to the </span><span><a href="http://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager03.html" target="_blank"><span>Global Storage Settings Panel</span></a></span></span><span> and </span><span>following the instructions (which may include instructions that explain, for example, how to delete existing Flash Cookies (referred to "information" on the Macromedia site), how to prevent Flash LSOs from being placed on your computer without your being asked, and (for Flash Player 8 and later) how to block Flash Cookies that are not being delivered by the operator of the page you are on at the time).</span></div>
        <span>Please note that setting the Flash Player to restrict or limit acceptance of Flash Cookies may reduce or impede the functionality of some Flash applications, including, potentially, Flash applications used in connection with our services or online content.</span>
        <div><strong>
          <h2>Do you serve targeted advertising?</h2>
        </strong></div>
        <span>Third parties may serve cookies on your computer or mobile device to serve advertising through our Website. These companies may use information about your visits to this and other websites in order to provide relevant advertisements about goods and services that you may be interested in. They may also employ technology that is used to measure the effectiveness of advertisements. They can accomplish this by using cookies or web beacons to collect information about your visits to this and other sites in order to provide relevant advertisements about goods and services of potential interest to you. The information collected through this process does not enable us or them to identify your name, contact details, or other details that directly identify you unless you choose to provide these.</span>
        <div><strong>
          <h2>How often will you update this Cookie Policy?</h2>
        </strong></div>
        <span>We may update </span><span>this Cookie Policy from time to time in order to reflect, for example, changes to the cookies we use or for other operational, legal, or regulatory reasons. Please therefore revisit this Cookie Policy regularly to stay informed about our use of cookies and related technologies.</span>
        <span>The date at the top of this Cookie Policy indicates when it was last updated.</span>
        <div><strong>
          <h2>Where can I get further information?</h2>
        </strong></div>
        <span>If you have any questions about our use of cookies or other technologies, please contact us at:</span>
        <span> founders@lmnr.ai </span>
      </div>
    </div>
  );
}
