/*
 * Copyright 2022-2024 Ponfee (http://www.ponfee.cn/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.ponfee.disjob.common.base;

import java.io.Closeable;
import java.util.Collections;
import java.util.Set;

/**
 * Representing startable
 *
 * @author Ponfee
 */
public interface Startable extends Closeable {

    /**
     * Returns list of dependencies startable
     *
     * @return dependency other startable
     */
    default Set<Startable> dependencies() {
        return Collections.emptySet();
    }

    /**
     * Start
     */
    void start();

    /**
     * Stop
     */
    void stop();

    /**
     * Close
     */
    @Override
    default void close() {
        stop();
    }

}
