/*
 * Copyright 2022-2024 Ponfee (http://www.ponfee.cn/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.ponfee.disjob.dispatch.http;

import cn.ponfee.disjob.common.base.TimingWheel;
import cn.ponfee.disjob.common.spring.RpcController;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.dispatch.ExecuteTaskParam;
import cn.ponfee.disjob.dispatch.TaskReceiver;

/**
 * Task receiver based http.
 *
 * @author Ponfee
 */
@RpcController
public class HttpTaskReceiver extends TaskReceiver implements HttpTaskController {

    public HttpTaskReceiver(Worker.Local localWorker, TimingWheel<ExecuteTaskParam> timingWheel) {
        super(localWorker, timingWheel);
    }

    @Override
    public boolean receive(ExecuteTaskParam param) {
        return super.doReceive(param);
    }

}
