---
sidebar_position: 3
---

# Governance

This project is led and managed by a benevolent dictator. The benevolent dictator is responsible for the general strategic direction in addition to the day-to-day maintenance of the project. The community guides the decisions of the benevolent dictator through active engagement and contribution.

This project has also adopted the code of conduct defined by the [Contributor Covenant](http://contributor-covenant.org/) to clarify expected behavior in our community. For more information see the [.NET Foundation Code of Conduct](http://www.dotnetfoundation.org/code-of-conduct).

### Roles and Responsibilities

#### Benevolent dictator (project leads)

In the WiX Toolset the role of Benevolent Dictator (project leads) is shared between [Rob Mensching](http://robmensching.com/) and [Bob Arnson](http://www.joyofsetup.com/). The project leads are expected to understand the community as a whole and strive to satisfy as many conflicting needs as possible, while ensuring that the project survives in the long term.

In many ways, the role of the benevolent dictator is less about dictatorship and more about diplomacy. The key is to ensure that, as the project expands, the right people are given influence over it and the community rallies behind the vision of the project leads.

Additionally, [.NET Foundation](http://dotnetfoundation.org/) staff considers the project leads as the primary point of contact or first point of contact for the project for purposes of business operations including domain registrations, and technical services (e.g. code-signing).

#### Committers

Committers are contributors who have made sustained valuable contributions to the project and are now relied upon to both write code directly to the repository. In many cases they are programmers but it is also possible that they contribute in a different role. Typically, a committer will focus on a specific aspect of the project, and will bring a level of expertise and understanding that earns them the respect of the community and the project lead. The role of committer is not an official one; it is simply a position that influential members of the community will find themselves in as the project lead looks to them for guidance and support.

Committers have no authority over the overall direction of the project. However, they do have the ear of the project leads. It is a committer's job to ensure that the lead is aware of the community's needs and collective objectives, and to help develop or elicit appropriate contributions to the project. Often, committers are given informal control over their specific areas of responsibility, and are assigned rights to directly modify certain areas of the source code. That is, although committers do not have explicit decision-making authority, they will often find that their actions are synonymous with the decisions made by the leads.

**How to become a Committer:** Be a regular Contributor then be appointed by the Benevolent Dictator.

#### Contributors

Contributors are community members who submit pull requests for the project. These pull requests may be a one-time occurrence or occur over time. The expectation is that that contributors will submit pull requests that are small at first. Ideally larger or more complex contributions are sent once the contributor has built confidence in the quality of their pull requests with the community.

Before a contributor's first pull request is put into the repository they must sign a [Contribution License Agreement](https://cla.dotnetfoundation.org/). The pull request can be submitted and discussed but it cannot be committed to the repository without the appropriate paperwork in place.

**How to become a Contributor:** Participate in the project as a [developer](../development/index.md).

#### Users

Users are community members who have a need for the project. They are the most important members of the community: without them, the project would have no purpose. Anyone can be a user; there are no specific requirements.

Users should be encouraged to participate in the life of the project and the community as much as possible. User contributions enable the project team to ensure that they are satisfying the needs of those users. Common user activities include (but are not limited to):

* Advocating the use of the project
* Informing developers of the project strength and weaknesses from a new user's perspective
* Providing moral support (a 'thank you' goes a long way)
* Writing [documentation](gethelp.md#doc)
* Filing [bug reports and feature requests](gethelp.md#bugs)
* Participating on the [mailing lists](gethelp.md#mailinglists) and [discussion forum](gethelp.md#forum)

Users who continue to engage with the project and its community will often find themselves becoming more and more involved. Such users may then go on to become Contributors, as described above.

**How to become a User:** Use the WiX toolset and participate on the [mailing lists](gethelp.md#mailinglists) and [discussion forum](gethelp.md#forum).
