---
wip: 4521
type: Feature
by: Bob Arnson (bob at joyofsetup.com)
title: WiX v4.x features should be planned
draft: false
---

## User stories

* As a WiX developer I can plan features for WiX v4.x such that WiX v4.x releases are smooth.


## Proposal

This WIP exists for the purpose of tracking work that's been proposed for WiX v4.x. For each feature, we need to know:

* **Target** version of WiX. Features might need to come in v4.0 because they're breaking changes. Others are internal or invisible changes and could come in any v4.x release. Some changes might come in multiple phases across multiple v4.x releases.
* **Status**: Features go through a typical workflow on their way from an idea to merged pull request. Use one of the following:
  * Proposed
  * WIP draft
  * Wix-devs discussion
  * Coding in progress
  * Pull request in progress
  * Complete
* **People**: Who's working on the feature. A feature might be driven and implemented by one person or multiple people could split work on the WIP and code and documentation and TPS reports.


Feature                 | Target  | WIP  | Status   | People
-------                 | ------- | ---  | ------   | ------
Bundle locators         | 4.x     | XXXX | Proposed | @
Burn searches in MSIs   | 4.x     | XXXX | Proposed | @
ARP authoring           | 4.x     | XXXX | Proposed | @
Condition references    | 4.0     | XXXX | Proposed | @barnson
Releases                | 4.x     | XXXX | Proposed | @
Generated ids           | 4.0     | ---- | Complete | @firegiantco
BundlePackage           | 4.x     | XXXX | Proposed | @
Generated product code  | 4.0     | XXXX | Proposed | @
Remove Package detritus | 4.0     | XXXX | Proposed | @
LZMA containers         | 4.0/4.x | XXXX | Proposed | @barnson
Binder info -> row      | 4.0     | ---- | Complete | @robmen
ICE support             | 4.0     | XXXX | Proposed | @barnson
ICE replacements        | 4.0/4.x | XXXX | Proposed | @
Migrate v3 source code  | 4.0     | [4561][] | Proposed | @firegiantco
Property persistence    | 4.x     | XXXX | Proposed | @
thmutil w/variables     | 4.0     | [4149][] | Complete | @rseanhall
Variable abstraction    | 4.0     | [4552][] | Pull request in progress | @rseanhall
BalUtil for MBA         | 4.0     | ---- | Complete | @rseanhall
Clean up MBA prereq     | 4.0     | [4161][] | Complete | @rseanhall
thmutil Button Actions  | 4.0     | [4658][] | Complete | @rseanhall
Modify Burn API         | 4.0     | [4773][] | WIP draft | @

For WIP, provide a link to the WIP. For People, use your GitHub user name.

## Considerations


## See Also

[Initial thread on wix-devs](http://windows-installer-xml-wix-toolset.687559.n2.nabble.com/16-things-I-d-like-to-see-in-WiX-v4-x-td7596286.html)


  [4149]: http://wixtoolset.org/development/wips/4149-thmutil-variable-support/
  [4161]: http://wixtoolset.org/development/wips/4161-allow-more-than-one-mbaprereq/
  [4552]: http://wixtoolset.org/development/wips/4552-variable-abstraction/
  [4561]: http://wixtoolset.org/development/wips/4561-migrate-v3-source-code-to-v4/
  [4658]: http://wixtoolset.org/development/wips/4658-builtin-thmutil-button-functionality/
  [4773]: http://wixtoolset.org/development/wixs/4773-modify-burn-api/
