---
sidebar_position: 5
---

# Get help

## Documentation {#doc}

* [WiX toolset v4.x][v4]
* [WiX toolset v3.x reference][v3]


## Discussions forum {#forum}

There is also a [Discussion forum on GitHub][ghtalk] that is an experiment. If 
we find that users prefer the forum over the mailing lists, we will remove the 
experimental status. At the moment, the Discussions forum gets less traffic 
than the mailing list so the experiment continues.


## Mailing lists {#mailinglists}

The mailing lists are a great place to ask questions, make suggestions, or
discuss the WiX toolset with other users and the WiX developers. To help prevent
spam on the WiX mailing lists, you must now subscribe to the lists before you
can send e-mail to them. To subscribe click one of the *Join* links below and
send the email or go to *Preferences* web page.

### WiX-users list {#wixusers}

Questions and discussion about the WiX toolset. This is the most active list and a great place to ask your questions or lurk if you just want to learn.

[Join](mailto:wix-users-request@lists.wixtoolset.org?subject=subscribe) | [Unsubscribe](mailto:wix-users-unsubscribe@lists.wixtoolset.org?subject=unsubscribe) | [Preferences](http://lists.wixtoolset.org/listinfo.cgi/wix-users-wixtoolset.org) | [Archive](http://lists.wixtoolset.org/pipermail/wix-users-wixtoolset.org/)


### WiX-devs list {#wixdevs}

Questions and discussion about developing the WiX toolset.

[Join](mailto:wix-devs-subscribe@lists.wixtoolset.org?subject=subscribe) | [Unsubscribe](mailto:wix-devs-unsubscribe@lists.wixtoolset.org?subject=unsubscribe) | [Preferences](http://lists.wixtoolset.org/listinfo.cgi/wix-devs-wixtoolset.org) | [Archive](http://lists.wixtoolset.org/pipermail/wix-devs-wixtoolset.org/)


## Bugs and feature requests {#bugs}

Bugs and feature requests for the WiX Toolset are [tracked on GitHub](https://github.com/wixtoolset/issues/issues).

If you think you've encountered a bug in the WiX Toolset or want to request a new feature, first search [the GitHub issue tracker](https://github.com/wixtoolset/issues/issues) to see if someone else has already reported it.

If nobody has, [open an issue on GitHub](https://github.com/wixtoolset/issues/issues/new/choose) and provide the following to help us narrow down, reproduce, and fix the problem.

* For a bug, which version of WiX, .NET, and Visual Studio you're using.
* If the problem happens when installing your packages built with WiX, include the version of Windows the package is running on.
* A description of the facts of the problem. Be as specific as you can and err on the side of providing too much information, including code, error messages, command lines you used to invoke the build, and so forth.
* A description of what you expected to happen.

Issues are triaged at biweekly online meetings, generally held every other Thursday at 9:30 AM Pacific time (UTC-7/UTC-8). Meeting requests are sent to the [wix-devs mailing list]. Highlights and a video recording of the meeting are posted after the meeting on the [FireGiant blog](https://www.firegiant.com/blog/).


## External resources

The following external resources are useful but not managed by the WiX community:

* [WiX v3.x Tutorial][tutorial]
* [WiX 3.6: A Developer's Guide to Windows Installer XML by Nick Ramirez][book1]
* [WiX Cookbook by Nick Ramirez][book2]
* [Stackoverflow tagged 'wix'][so]
* [FireGiant WiX Knowledge Base][fg]

[v3]: wix3.md
[v4]: intro.md
[tutorial]: https://www.firegiant.com/wix/tutorial/
[book1]: https://www.packtpub.com/product/wix-3-6-a-developer-s-guide-to-windows-installer-xml/9781782160427
[book2]: https://www.packtpub.com/product/wix-cookbook/9781784393212
[so]: https://stackoverflow.com/questions/tagged/wix?sort=newest
[fg]: https://support.firegiant.com/forums
[ghtalk]: https://github.com/wixtoolset/issues/discussions
[wix-devs mailing list]: gethelp.md#wixdevs
