---
title: Fragment Element
layout: documentation_xsd_main
---
<dl>
  <dt>Description</dt>
  <dd>                 The Fragment element is the building block of creating an installer database in WiX.  Once defined,                 the Fragment becomes an immutable, atomic unit which can either be completely included or excluded                 from a product.  The contents of a Fragment element can be linked into a product by utilizing one                 of the many *Ref elements.  When linking in a Fragment, it will be necessary to link in all of its                 individual units.  For instance, if a given Fragment contains two Component elements, you must link                 both under features using ComponentRef for each linked Component.  Otherwise, you will get a linker                 warning and have a floating Component that does not appear under any Feature.             </dd>
  <dt>Windows Installer references</dt>
  <dd>None</dd>
  <dt>Parents</dt>
  <dd>
    <a href="../wix/">Wix</a>
  </dd>
  <dt>Inner Text</dt>
  <dd>None</dd>
  <dt>Children</dt>
  <dd>Choice of elements (min: 0, max: unbounded)<ul><li><a href="../appid/">AppId</a> (min: 0, max: unbounded)</li><li><a href="../binary/">Binary</a> (min: 0, max: unbounded)</li><li><a href="../bootstrapperapplication/">BootstrapperApplication</a> (min: 0, max: unbounded)</li><li><a href="../bootstrapperapplicationref/">BootstrapperApplicationRef</a> (min: 0, max: unbounded)</li><li><a href="../compliancecheck/">ComplianceCheck</a> (min: 0, max: unbounded)</li><li><a href="../component/">Component</a> (min: 0, max: unbounded)</li><li><a href="../componentgroup/">ComponentGroup</a> (min: 0, max: unbounded)</li><li><a href="../condition/">Condition</a> (min: 0, max: unbounded)</li><li><a href="../container/">Container</a> (min: 0, max: unbounded)</li><li><a href="../customaction/">CustomAction</a> (min: 0, max: unbounded)</li><li><a href="../customactionref/">CustomActionRef</a> (min: 0, max: unbounded)</li><li><a href="../customtable/">CustomTable</a> (min: 0, max: unbounded)</li><li><a href="../directory/">Directory</a> (min: 0, max: unbounded)</li><li><a href="../directoryref/">DirectoryRef</a> (min: 0, max: unbounded)</li><li><a href="../embeddedchainer/">EmbeddedChainer</a> (min: 0, max: unbounded)</li><li><a href="../embeddedchainerref/">EmbeddedChainerRef</a> (min: 0, max: unbounded)</li><li><a href="../ensuretable/">EnsureTable</a> (min: 0, max: unbounded)</li><li><a href="../feature/">Feature</a> (min: 0, max: unbounded)</li><li><a href="../featuregroup/">FeatureGroup</a> (min: 0, max: unbounded)</li><li><a href="../featureref/">FeatureRef</a> (min: 0, max: unbounded)</li><li><a href="../icon/">Icon</a> (min: 0, max: unbounded)</li><li><a href="../ignoremodularization/">IgnoreModularization</a> (min: 0, max: unbounded)</li><li><a href="../media/">Media</a> (min: 0, max: unbounded)</li><li><a href="../mediatemplate/">MediaTemplate</a> (min: 0, max: unbounded)</li><li><a href="../packagecertificates/">PackageCertificates</a> (min: 0, max: unbounded)</li><li><a href="../packagegroup/">PackageGroup</a> (min: 0, max: unbounded)</li><li><a href="../patchcertificates/">PatchCertificates</a> (min: 0, max: unbounded)</li><li><a href="../patchfamily/">PatchFamily</a> (min: 0, max: unbounded)</li><li><a href="../patchfamilygroup/">PatchFamilyGroup</a> (min: 0, max: unbounded)</li><li><a href="../payloadgroup/">PayloadGroup</a> (min: 0, max: unbounded)</li><li><a href="../property/">Property</a> (min: 0, max: unbounded)</li><li><a href="../propertyref/">PropertyRef</a> (min: 0, max: unbounded)</li><li><a href="../relatedbundle/">RelatedBundle</a> (min: 0, max: unbounded)</li><li><a href="../setdirectory/">SetDirectory</a> (min: 0, max: unbounded)</li><li><a href="../setproperty/">SetProperty</a> (min: 0, max: unbounded)</li><li><a href="../sfpcatalog/">SFPCatalog</a> (min: 0, max: unbounded)</li><li><a href="../ui/">UI</a> (min: 0, max: unbounded)</li><li><a href="../uiref/">UIRef</a> (min: 0, max: unbounded)</li><li><a href="../upgrade/">Upgrade</a> (min: 0, max: unbounded)</li><li><a href="../variable/">Variable</a> (min: 0, max: unbounded)</li><li><a href="../wixvariable/">WixVariable</a> (min: 0, max: unbounded)</li><li>Sequence (min: 1, max: 1)<ol><li><a href="../installexecutesequence/">InstallExecuteSequence</a> (min: 0, max: 1)</li><li><a href="../installuisequence/">InstallUISequence</a> (min: 0, max: 1)</li><li><a href="../adminexecutesequence/">AdminExecuteSequence</a> (min: 0, max: 1)</li><li><a href="../adminuisequence/">AdminUISequence</a> (min: 0, max: 1)</li><li><a href="../advertiseexecutesequence/">AdvertiseExecuteSequence</a> (min: 0, max: 1)</li></ol></li><li><span class="extension">Any Element (namespace='##other' processContents='Lax')                          Extensibility point in the WiX XML Schema.  Schema extensions can register additional                         elements at this point in the schema.                     </span><ul><li><a href="../bootstrapperapplication/">BootstrapperApplication</a></li><li><a href="../bootstrapperapplicationref/">BootstrapperApplicationRef</a></li><li><a href="../../util/closeapplication" class="extension">CloseApplication</a></li><li><a href="../../complus/complusapplication" class="extension">ComPlusApplication</a></li><li><a href="../../complus/complusapplicationrole" class="extension">ComPlusApplicationRole</a></li><li><a href="../../complus/compluspartition" class="extension">ComPlusPartition</a></li><li><a href="../../complus/compluspartitionrole" class="extension">ComPlusPartitionRole</a></li><li><a href="../../util/componentsearch" class="extension">ComponentSearch</a></li><li><a href="../../util/componentsearchref" class="extension">ComponentSearchRef</a></li><li><a href="../../bal/condition" class="extension">Condition</a></li><li><a href="../../util/directorysearch" class="extension">DirectorySearch</a></li><li><a href="../../util/directorysearchref" class="extension">DirectorySearchRef</a></li><li><a href="../../util/filesearch" class="extension">FileSearch</a></li><li><a href="../../util/filesearchref" class="extension">FileSearchRef</a></li><li><a href="../../util/group" class="extension">Group</a></li><li><a href="../../vs/helpcollectionref" class="extension">HelpCollectionRef</a></li><li><a href="../../vs/helpfilter" class="extension">HelpFilter</a></li><li><a href="../../lux/mutation" class="extension">Mutation</a></li><li><a href="../packagegroup/">PackageGroup</a></li><li><a href="../payloadgroup/">PayloadGroup</a></li><li><a href="../../util/productsearch" class="extension">ProductSearch</a></li><li><a href="../../util/productsearchref" class="extension">ProductSearchRef</a></li><li><a href="../../util/registrysearch" class="extension">RegistrySearch</a></li><li><a href="../../util/registrysearchref" class="extension">RegistrySearchRef</a></li><li><a href="../relatedbundle/">RelatedBundle</a></li><li><a href="../../dependency/requires" class="extension">Requires</a></li><li><a href="../../util/restartresource" class="extension">RestartResource</a></li><li><a href="../../sql/sqldatabase" class="extension">SqlDatabase</a></li><li><a href="../../lux/unittest" class="extension">UnitTest</a></li><li><a href="../../lux/unittestref" class="extension">UnitTestRef</a></li><li><a href="../update/">Update</a></li><li><a href="../../util/user" class="extension">User</a></li><li><a href="../ux/">UX</a></li><li><a href="../variable/">Variable</a></li><li><a href="../../iis/webapplication" class="extension">WebApplication</a></li><li><a href="../../iis/webapppool" class="extension">WebAppPool</a></li><li><a href="../../iis/webdirproperties" class="extension">WebDirProperties</a></li><li><a href="../../iis/weblog" class="extension">WebLog</a></li><li><a href="../../iis/website" class="extension">WebSite</a></li></ul></li></ul></dd>
  <dt>Attributes</dt>
  <dd>
    <table cellspacing="0" cellpadding="0" class="schema">
      <tr>
        <th width="15%">Name</th>
        <th width="15%">Type</th>
        <th width="65%">Description</th>
        <th width="15%">Required</th>
      </tr>
      <tr>
        <td>Id</td>
        <td>String</td>
        <td>                     Optional identifier for a Fragment.  Should only be set by advanced users to tag sections.                 </td>
        <td>&nbsp;</td>
      </tr>
    </table>
  </dd>
  <dt>See Also</dt>
  <dd>
    <a href="../">Wix Schema</a>
  </dd>
</dl>
