---
title: RegistryKey Element
layout: documentation_xsd_main
---
<dl>
  <dt>Description</dt>
  <dd>                 Used for organization of child RegistryValue elements or to create a registry key                 (and optionally remove it during uninstallation).             </dd>
  <dt>Windows Installer references</dt>
  <dd>
    <a href="http://msdn.microsoft.com/library/aa371168.aspx" target="_blank">Registry Table</a>
  </dd>
  <dt>Parents</dt>
  <dd>
    <a href="../component/">Component</a>, <a href="../registrykey/">RegistryKey</a></dd>
  <dt>Inner Text</dt>
  <dd>None</dd>
  <dt>Children</dt>
  <dd>Choice of elements (min: 0, max: unbounded)<ul><li><a href="../permission/">Permission</a> (min: 0, max: unbounded): ACL permission</li><li><a href="../permissionex/">PermissionEx</a> (min: 0, max: unbounded): Can also configure the ACLs for this registry key.</li><li><a href="../registrykey/">RegistryKey</a> (min: 0, max: unbounded)</li><li><a href="../registryvalue/">RegistryValue</a> (min: 0, max: unbounded)</li><li><span class="extension">Any Element (namespace='##other' processContents='Lax')                              Extensibility point in the WiX XML Schema.  Schema extensions can register additional                             elements at this point in the schema.                         </span><ul><li><a href="../../util/permissionex" class="extension">PermissionEx</a></li></ul></li></ul></dd>
  <dt>Attributes</dt>
  <dd>
    <table cellspacing="0" cellpadding="0" class="schema">
      <tr>
        <th width="15%">Name</th>
        <th width="15%">Type</th>
        <th width="65%">Description</th>
        <th width="15%">Required</th>
      </tr>
      <tr>
        <td>Action</td>
        <td>Enumeration</td>
        <td>                         The Action attribute has been deprecated. In most cases, you can simply omit @Action.  If you need to force Windows Installer                          to create an empty key or recursively delete the key, use the ForceCreateOnInstall or ForceDeleteOnUninstall attributes instead.                       This attribute's value must be one of the following:<dl><dt class="enumerationValue"><dfn>create</dfn></dt><dd>                                     Creates the key, if absent, when the parent component is installed.                                 </dd><dt class="enumerationValue"><dfn>createAndRemoveOnUninstall</dfn></dt><dd>                                     Creates the key, if absent, when the parent component is installed then remove the key with all its values and subkeys when the parent component is uninstalled.                                     Note that this value is useful only if your program creates additional values or subkeys under this key and you want an uninstall to remove them. MSI already                                     removes all values and subkeys that it creates, so this option just adds additional overhead to uninstall.                                 </dd><dt class="enumerationValue"><dfn>none</dfn></dt><dd>                                     Does nothing; this element is used merely in WiX authoring for organization and does nothing to the final output.                                     This is the default value.                                 </dd></dl></td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>ForceCreateOnInstall</td>
        <td><a href="../simple_type_yesnotype/">YesNoType</a></td>
        <td>                         Set this attribute to 'yes' to create an empty key, if absent, when the parent component is installed.                         This value is needed only to create an empty key with no subkeys or values. Windows Installer creates                         keys as needed to store subkeys and values. The default is "no".                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>ForceDeleteOnUninstall</td>
        <td><a href="../simple_type_yesnotype/">YesNoType</a></td>
        <td>                         Set this attribute to 'yes' to remove the key with all its values and subkeys when the parent component is uninstalled.                         Note that this value is useful only if your program creates additional values or subkeys under this key and you want an uninstall to remove them. MSI already                         removes all values and subkeys that it creates, so this option just adds additional overhead to uninstall.                         The default is "no".                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Id</td>
        <td>String</td>
        <td>                         Primary key used to identify this particular entry.  If this attribute is not specified, an identifier will be                         generated by hashing the parent Component identifier, Root, Key, and Name.                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Key</td>
        <td>String</td>
        <td>                         The localizable key for the registry value.                         If the parent element is a RegistryKey, this value may be omitted to use the                         path of the parent, or if its specified it will be appended to the path of the parent.                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Root</td>
        <td><a href="../simple_type_registryroottype/">RegistryRootType</a></td>
        <td>                         The predefined root key for the registry value.                     </td>
        <td>&nbsp;</td>
      </tr>
    </table>
  </dd>
  <dt>How Tos and Examples</dt>
  <dd>
    <ul>
      <li>
        <a href="../../../howtos/files_and_registry/read_a_registry_entry">How To: Read a registry entry during installation</a>
      </li>
      <li>
        <a href="../../../howtos/files_and_registry/write_a_registry_entry">How To: Write a registry entry during installation</a>
      </li>
    </ul>
  </dd>
  <dt>See Also</dt>
  <dd>
    <a href="../">Wix Schema</a>
  </dd>
</dl>
