---
title: RegistryValue Element
layout: documentation_xsd_main
---
<dl>
  <dt>Description</dt>
  <dd>                 Used to create a registry value.  For multi-string values, this can be used to prepend or append values.<br/><br/>                For legacy authoring: Use several of these elements to specify each registry value in a multiString registry value.  This element                 cannot be used if the Value attribute is specified unless the Type attribute is set to 'multiString'.  The                 values should go in the text area of the RegistryValue element.             </dd>
  <dt>Windows Installer references</dt>
  <dd>
    <a href="http://msdn.microsoft.com/library/aa371168.aspx" target="_blank">Registry Table</a>
  </dd>
  <dt>Parents</dt>
  <dd>
    <a href="../component/">Component</a>, <a href="../registry/">Registry</a>, <a href="../registrykey/">RegistryKey</a></dd>
  <dt>Inner Text (xs:string)</dt>
  <dd>This element may have inner text.</dd>
  <dt>Children</dt>
  <dd>Choice of elements (min: 0, max: unbounded)<ul><li><a href="../multistringvalue/">MultiStringValue</a> (min: 0, max: unbounded)</li><li><a href="../permission/">Permission</a> (min: 0, max: unbounded)</li><li><a href="../permissionex/">PermissionEx</a> (min: 0, max: unbounded): Can also configure the ACLs for this registry value.</li><li><span class="extension">Any Element (namespace='##other' processContents='Lax')                              Extensibility point in the WiX XML Schema.  Schema extensions can register additional                             elements at this point in the schema.                         </span><ul><li><a href="../../util/permissionex" class="extension">PermissionEx</a></li></ul></li></ul></dd>
  <dt>Attributes</dt>
  <dd>
    <table cellspacing="0" cellpadding="0" class="schema">
      <tr>
        <th width="15%">Name</th>
        <th width="15%">Type</th>
        <th width="65%">Description</th>
        <th width="15%">Required</th>
      </tr>
      <tr>
        <td>Action</td>
        <td>Enumeration</td>
        <td>                         This is the action that will be taken for this registry value.                       This attribute's value must be one of the following:<dl><dt class="enumerationValue"><dfn>append</dfn></dt><dd>                                     Appends the specified value(s) to a multiString registry value.                                 </dd><dt class="enumerationValue"><dfn>prepend</dfn></dt><dd>                                     Prepends the specified value(s) to a multiString registry value.                                 </dd><dt class="enumerationValue"><dfn>write</dfn></dt><dd>                                     Writes a registry value.  This is the default value.                                 </dd></dl></td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Id</td>
        <td>String</td>
        <td>                         Primary key used to identify this particular entry.  If this attribute is not specified, an identifier will be                         generated by hashing the parent Component identifier, Root, Key, and Name.                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Key</td>
        <td>String</td>
        <td>                         The localizable key for the registry value.                         If the parent element is a RegistryKey, this value may be omitted to use the                         path of the parent, or if its specified it will be appended to the path of the parent.                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>KeyPath</td>
        <td><a href="../simple_type_yesnotype/">YesNoType</a></td>
        <td>                         Set this attribute to 'yes' to make this registry key the KeyPath of the parent component.                         Only one resource (registry, file, etc) can be the KeyPath of a component.                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Name</td>
        <td>String</td>
        <td>                         The localizable registry value name.  If this attribute is not provided the default value for the registry key will                         be set instead.  The Windows Installer allows several special values to be set for this attribute.  You should not                         use them in WiX.  Instead use appropriate values in the Action attribute to get the desired behavior.                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Root</td>
        <td><a href="../simple_type_registryroottype/">RegistryRootType</a></td>
        <td>                         The predefined root key for the registry value.                     </td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Type</td>
        <td>Enumeration</td>
        <td>                         Set this attribute to the type of the desired registry key.  This attribute must be specified whenever the Value                         attribute or a child RegistryValue element is specified.    This attribute                         should only be set when the value of the Action attribute does not include the word 'remove'.                       This attribute's value must be one of the following:<dl><dt class="enumerationValue"><dfn>string</dfn></dt><dd>                                     The value is interpreted and stored as a string (REG_SZ).                                 </dd><dt class="enumerationValue"><dfn>integer</dfn></dt><dd>                                     The value is interpreted and stored as an integer (REG_DWORD).                                 </dd><dt class="enumerationValue"><dfn>binary</dfn></dt><dd>                                     The value is interpreted and stored as a hexadecimal value (REG_BINARY).                                 </dd><dt class="enumerationValue"><dfn>expandable</dfn></dt><dd>                                     The value is interpreted and stored as an expandable string (REG_EXPAND_SZ).                                 </dd><dt class="enumerationValue"><dfn>multiString</dfn></dt><dd>                                     The value is interpreted and stored as a multiple strings (REG_MULTI_SZ).                                     Please note that this value will only result in a multi-string value if there is more than one registry value                                     or the Action attribute's value is 'append' or 'prepend'.  Otherwise a string value will be created.                                 </dd></dl></td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>Value</td>
        <td>String</td>
        <td>                         Set this attribute to the localizable registry value.  This value is formatted.  The Windows Installer allows                         several special values to be set for this attribute.  You should not use them in WiX.  Instead use appropriate                         values in the Type attribute to get the desired behavior.                     </td>
        <td>&nbsp;</td>
      </tr>
    </table>
  </dd>
  <dt>How Tos and Examples</dt>
  <dd>
    <ul>
      <li>
        <a href="../../../howtos/files_and_registry/write_a_registry_entry">How To: Write a registry entry during installation</a>
      </li>
    </ul>
  </dd>
  <dt>See Also</dt>
  <dd>
    <a href="../">Wix Schema</a>
  </dd>
</dl>
