##############################################################################
# Copyright (c) 2013-2016, Lawrence Livermore National Security, LLC.
# Produced at the Lawrence Livermore National Laboratory.
#
# This file is part of Spack.
# Created by Todd Gamblin, tgamblin@llnl.gov, All rights reserved.
# LLNL-CODE-647188
#
# For details, see https://github.com/llnl/spack
# Please also see the LICENSE file for our notice and the LGPL.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License (as
# published by the Free Software Foundation) version 2.1, February 1999.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
# conditions of the GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
##############################################################################
from spack import *

class Cairo(Package):
    """Cairo is a 2D graphics library with support for multiple output devices."""
    homepage = "http://cairographics.org"
    url      = "http://cairographics.org/releases/cairo-1.14.0.tar.xz"

    version('1.14.0', 'fc3a5edeba703f906f2241b394f0cced')

    depends_on("libpng")
    depends_on("glib")
    depends_on("pixman")
    depends_on("fontconfig@2.10.91:") # Require newer version of fontconfig.

    def install(self, spec, prefix):
        configure("--prefix=%s" % prefix,
                  "--disable-trace", # can cause problems with libiberty
                  "--enable-tee")
        make()
        make("install")
