# OTPAnalyzer

![OTPAnalyzer Icon](https://github.com/dsmurfin/OTPAnalyzer/blob/main/OTPAnalyzer/Assets.xcassets/AppIcon.appiconset/IconMac128.png)

A macOS application for testing and evaluating ANSI E1.59 - 2021, Entertainment Technology - Object Transform Protocol (OTP).

Provides complete protocol implementations of OTP Producer and Consumer components using IPv4/6 (OTP-4, OTP-6, OTP-4/6).

Current revision: Document Number: CP/2018-1034r5.

[Download](https://tsp.esta.org/tsp/documents/published_docs.php) the full standard document.

## Getting Started

These instructions will get you a copy of the project up and running on your local machine for development and testing purposes. See deployment for notes on how to deploy the project on a live system.

### Prerequisites

macOS 10.14+

### Installing

Download the repository and open the Xcode project, or access pre-built app zips from the [releases](https://github.com/dsmurfin/OTPAnalyzer/releases) page. Select a release and then expand assets.

## Deployment

This application should not be used for deployment to a live system. It is provided solely for testing and evaluation.

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://github.com/dsmurfin/OTPAnalyzer/tags). 

## Authors

* **Daniel Murfin** - *Initial work* - [dsmurfin](https://github.com/dsmurfin)

See also the list of [contributors](https://github.com/dsmurfin/OTPAnalyzer/graphs/contributors) who participated in this project.

## License

This project is licensed under the MIT License - see the [LICENSE.md](LICENSE.md) file for details

## Acknowledgments

* OTP library dependency [OTPKit](https://github.com/dsmurfin/OTPKit)
* Socket library dependency [CocoaSyncSocket](https://github.com/robbiehanson/CocoaAsyncSocket)
* Includes [CwlUtils](https://github.com/mattgallagher/CwlUtils) from [Matt Gallagher] (https://www.cocoawithlove.com)
