package io.quarkus.deployment;

import io.quarkus.deployment.builditem.FeatureBuildItem;

/**
 * Represents a feature provided by a core extension.
 *
 * @see FeatureBuildItem
 */
public enum Feature {

    AGROAL,
    AMAZON_DYNAMODB,
    AMAZON_LAMBDA,
    AMAZON_S3,
    AMAZON_SNS,
    AMAZON_SQS,
    AMAZON_SES,
    AMAZON_KMS,
    ARTEMIS_CORE,
    ARTEMIS_JMS,
    CACHE,
    CDI,
    CONFIG_YAML,
    CONSUL_CONFIG,
    ELASTICSEARCH_REST_CLIENT_COMMON,
    ELASTICSEARCH_REST_CLIENT,
    ELASTICSEARCH_REST_HIGH_LEVEL_CLIENT,
    FLYWAY,
    GRPC_CLIENT,
    GRPC_SERVER,
    HIBERNATE_ORM,
    HIBERNATE_ENVERS,
    HIBERNATE_ORM_PANACHE,
    HIBERNATE_ORM_PANACHE_KOTLIN,
    HIBERNATE_ORM_REST_DATA_PANACHE,
    HIBERNATE_REACTIVE,
    HIBERNATE_SEARCH_ELASTICSEARCH,
    HIBERNATE_VALIDATOR,
    INFINISPAN_CLIENT,
    INFINISPAN_EMBEDDED,
    JAEGER,
    JDBC_DB2,
    JDBC_DERBY,
    JDBC_H2,
    JDBC_POSTGRESQL,
    JDBC_MARIADB,
    JDBC_MSSQL,
    JDBC_MYSQL,
    JGIT,
    JSCH,
    KAFKA_STREAMS,
    KEYCLOAK_AUTHORIZATION,
    KOTLIN,
    KUBERNETES,
    KUBERNETES_CLIENT,
    LIQUIBASE,
    LOGGING_GELF,
    MAILER,
    MONGODB_CLIENT,
    MONGODB_PANACHE,
    MONGODB_PANACHE_KOTLIN,
    MUTINY,
    NARAYANA_JTA,
    NARAYANA_STM,
    REACTIVE_PG_CLIENT,
    REACTIVE_MYSQL_CLIENT,
    REACTIVE_DB2_CLIENT,
    NEO4J,
    OIDC,
    PICOCLI,
    QUTE,
    REDIS_CLIENT,
    RESTEASY,
    RESTEASY_JACKSON,
    RESTEASY_JAXB,
    RESTEASY_JSONB,
    RESTEASY_MUTINY,
    RESTEASY_QUTE,
    REST_CLIENT,
    REST_CLIENT_JACKSON,
    REST_CLIENT_JAXB,
    REST_CLIENT_JSONB,
    SCALA,
    SCHEDULER,
    SECURITY,
    SECURITY_JDBC,
    SECURITY_LDAP,
    SECURITY_JPA,
    SECURITY_PROPERTIES_FILE,
    SECURITY_OAUTH2,
    SERVLET,
    SMALLRYE_CONTEXT_PROPAGATION,
    SMALLRYE_FAULT_TOLERANCE,
    SMALLRYE_HEALTH,
    SMALLRYE_JWT,
    SMALLRYE_METRICS,
    SMALLRYE_OPENAPI,
    SMALLRYE_OPENTRACING,
    SMALLRYE_REACTIVE_MESSAGING,
    SMALLRYE_REACTIVE_MESSAGING_KAFKA,
    SMALLRYE_REACTIVE_MESSAGING_AMQP,
    SMALLRYE_REACTIVE_MESSAGING_MQTT,
    SMALLRYE_REACTIVE_STREAMS_OPERATORS,
    SMALLRYE_REACTIVE_TYPE_CONVERTERS,
    SMALLRYE_GRAPHQL,
    SPRING_DI,
    SPRING_WEB,
    SPRING_DATA_JPA,
    SPRING_SECURITY,
    SPRING_BOOT_PROPERTIES,
    SPRING_CACHE,
    SPRING_CLOUD_CONFIG_CLIENT,
    SPRING_SCHEDULED,
    SWAGGER_UI,
    TIKA,
    UNDERTOW_WEBSOCKETS,
    VAULT,
    VERTX,
    VERTX_WEB,
    VERTX_GRAPHQL,
    WEBJARS_LOCATOR;

    public String getName() {
        return toString().toLowerCase().replace("_", "-");
    }

}
