'use strict';

const db = require('../db');

// DELETE "path/to/mailbox"
module.exports = (server, mailboxHandler) => (path, session, callback) => {
    server.logger.debug(
        {
            tnx: 'delete',
            cid: session.id
        },
        '[%s] DELETE "%s"',
        session.id,
        path
    );

    db.database.collection('mailboxes').findOne(
        {
            user: session.user.id,
            path
        },
        (err, mailbox) => {
            if (err) {
                return callback(err);
            }
            if (!mailbox) {
                return callback(null, 'NONEXISTENT');
            }

            mailboxHandler.del(session.user.id, mailbox._id, callback);
        }
    );
};
