/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.util.io;

import java.io.IOException;
import sound.jarnbjo.util.io.BitInputStream;

public final class HuffmanNode {
    private HuffmanNode parent;
    private int depth = 0;
    protected HuffmanNode o0;
    protected HuffmanNode o1;
    protected Integer value;
    private boolean full = false;

    public HuffmanNode() {
        this(null);
    }

    protected HuffmanNode(HuffmanNode huffmanNode) {
        this.parent = huffmanNode;
        if (huffmanNode != null) {
            this.depth = huffmanNode.getDepth() + 1;
        }
    }

    protected HuffmanNode(HuffmanNode huffmanNode, int n) {
        this(huffmanNode);
        this.value = new Integer(n);
        this.full = true;
    }

    protected int read(BitInputStream bitInputStream) throws IOException {
        HuffmanNode huffmanNode = this;
        while (huffmanNode.value == null) {
            huffmanNode = bitInputStream.getBit() ? huffmanNode.o1 : huffmanNode.o0;
        }
        return huffmanNode.value;
    }

    protected HuffmanNode get0() {
        return this.o0 == null ? this.set0(new HuffmanNode(this)) : this.o0;
    }

    protected HuffmanNode get1() {
        return this.o1 == null ? this.set1(new HuffmanNode(this)) : this.o1;
    }

    protected Integer getValue() {
        return this.value;
    }

    private HuffmanNode getParent() {
        return this.parent;
    }

    protected int getDepth() {
        return this.depth;
    }

    private boolean isFull() {
        return this.full ? true : (this.full = this.o0 != null && this.o0.isFull() && this.o1 != null && this.o1.isFull());
    }

    private HuffmanNode set0(HuffmanNode huffmanNode) {
        this.o0 = huffmanNode;
        return this.o0;
    }

    private HuffmanNode set1(HuffmanNode huffmanNode) {
        this.o1 = huffmanNode;
        return this.o1;
    }

    private void setValue(Integer n) {
        this.full = true;
        this.value = n;
    }

    public boolean setNewValue(int n, int n2) {
        if (this.isFull()) {
            return false;
        }
        if (n == 1) {
            if (this.o0 == null) {
                this.set0(new HuffmanNode(this, n2));
                return true;
            }
            if (this.o1 == null) {
                this.set1(new HuffmanNode(this, n2));
                return true;
            }
            return false;
        }
        return this.get0().setNewValue(n - 1, n2) ? true : this.get1().setNewValue(n - 1, n2);
    }
}

