/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.vorbis;

import java.io.IOException;
import sound.jarnbjo.util.io.BitInputStream;
import sound.jarnbjo.vorbis.Mapping0;
import sound.jarnbjo.vorbis.SetupHeader;
import sound.jarnbjo.vorbis.VorbisFormatException;
import sound.jarnbjo.vorbis.VorbisStream;

public abstract class Mapping {
    protected static Mapping createInstance(VorbisStream vorbisStream, BitInputStream bitInputStream, SetupHeader setupHeader) throws VorbisFormatException, IOException {
        int n = bitInputStream.getInt(16);
        switch (n) {
            case 0: {
                return new Mapping0(vorbisStream, bitInputStream, setupHeader);
            }
        }
        throw new VorbisFormatException("Mapping type " + n + " is not supported.");
    }

    protected abstract int getType();

    protected abstract int[] getAngles();

    protected abstract int[] getMagnitudes();

    protected abstract int[] getMux();

    protected abstract int[] getSubmapFloors();

    protected abstract int[] getSubmapResidues();

    protected abstract int getCouplingSteps();

    protected abstract int getSubmaps();
}

