/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.vorbis;

import java.io.IOException;
import sound.jarnbjo.util.io.BitInputStream;
import sound.jarnbjo.vorbis.Mapping;
import sound.jarnbjo.vorbis.SetupHeader;
import sound.jarnbjo.vorbis.Util;
import sound.jarnbjo.vorbis.VorbisFormatException;
import sound.jarnbjo.vorbis.VorbisStream;

public class Mapping0
extends Mapping {
    private int[] magnitudes;
    private int[] angles;
    private int[] mux;
    private int[] submapFloors;
    private int[] submapResidues;

    protected Mapping0(VorbisStream vorbisStream, BitInputStream bitInputStream, SetupHeader setupHeader) throws VorbisFormatException, IOException {
        int n;
        int n2;
        int n3 = 1;
        if (bitInputStream.getBit()) {
            n3 = bitInputStream.getInt(4) + 1;
        }
        int n4 = vorbisStream.getIdentificationHeader().getChannels();
        int n5 = Util.ilog(n4 - 1);
        if (bitInputStream.getBit()) {
            n2 = bitInputStream.getInt(8) + 1;
            this.magnitudes = new int[n2];
            this.angles = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.magnitudes[n] = bitInputStream.getInt(n5);
                this.angles[n] = bitInputStream.getInt(n5);
                if (this.magnitudes[n] != this.angles[n] && this.magnitudes[n] < n4 && this.angles[n] < n4) continue;
                System.err.println(this.magnitudes[n]);
                System.err.println(this.angles[n]);
                throw new VorbisFormatException("The channel magnitude and/or angle mismatch.");
            }
        } else {
            this.magnitudes = new int[0];
            this.angles = new int[0];
        }
        if (bitInputStream.getInt(2) != 0) {
            throw new VorbisFormatException("A reserved mapping field has an invalid value.");
        }
        this.mux = new int[n4];
        if (n3 > 1) {
            for (n2 = 0; n2 < n4; ++n2) {
                this.mux[n2] = bitInputStream.getInt(4);
                if (this.mux[n2] <= n3) continue;
                throw new VorbisFormatException("A mapping mux value is higher than the number of submaps");
            }
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                this.mux[n2] = 0;
            }
        }
        this.submapFloors = new int[n3];
        this.submapResidues = new int[n3];
        n2 = setupHeader.getFloors().length;
        n = setupHeader.getResidues().length;
        for (int i = 0; i < n3; ++i) {
            bitInputStream.getInt(8);
            this.submapFloors[i] = bitInputStream.getInt(8);
            this.submapResidues[i] = bitInputStream.getInt(8);
            if (this.submapFloors[i] > n2) {
                throw new VorbisFormatException("A mapping floor value is higher than the number of floors.");
            }
            if (this.submapResidues[i] <= n) continue;
            throw new VorbisFormatException("A mapping residue value is higher than the number of residues.");
        }
    }

    @Override
    protected int getType() {
        return 0;
    }

    @Override
    protected int[] getAngles() {
        return this.angles;
    }

    @Override
    protected int[] getMagnitudes() {
        return this.magnitudes;
    }

    @Override
    protected int[] getMux() {
        return this.mux;
    }

    @Override
    protected int[] getSubmapFloors() {
        return this.submapFloors;
    }

    @Override
    protected int[] getSubmapResidues() {
        return this.submapResidues;
    }

    @Override
    protected int getCouplingSteps() {
        return this.angles.length;
    }

    @Override
    protected int getSubmaps() {
        return this.submapFloors.length;
    }
}

