/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.vorbis;

import sound.jarnbjo.vorbis.Floor;

public final class Util {
    public static final int ilog(int n) {
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    public static final float float32unpack(int n) {
        float f = n & 0x1FFFFF;
        float f2 = (n & 0x7FE00000) >> 21;
        if ((n & Integer.MIN_VALUE) != 0) {
            f = -f;
        }
        return f * (float)Math.pow(2.0, (double)f2 - 788.0);
    }

    public static final int lookup1Values(int n, int n2) {
        int n3 = (int)Math.pow(Math.E, Math.log(n) / (double)n2);
        return Util.intPow(n3 + 1, n2) <= n ? n3 + 1 : n3;
    }

    public static final int intPow(int n, int n2) {
        int n3 = 1;
        while (n2 > 0) {
            --n2;
            n3 *= n;
        }
        return n3;
    }

    public static final boolean isBitSet(int n, int n2) {
        return (n & 1 << n2) != 0;
    }

    public static final int icount(int n) {
        int n2 = 0;
        while (n > 0) {
            n2 += n & 1;
            n >>= 1;
        }
        return n2;
    }

    public static final int lowNeighbour(int[] nArray, int n) {
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < nArray.length && i < n; ++i) {
            if (nArray[i] <= n2 || nArray[i] >= nArray[n]) continue;
            n2 = nArray[i];
            n3 = i;
        }
        return n3;
    }

    public static final int highNeighbour(int[] nArray, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        for (int i = 0; i < nArray.length && i < n; ++i) {
            if (nArray[i] >= n2 || nArray[i] <= nArray[n]) continue;
            n2 = nArray[i];
            n3 = i;
        }
        return n3;
    }

    public static final int renderPoint(int n, int n2, int n3, int n4, int n5) {
        int n6 = n4 - n3;
        int n7 = n6 < 0 ? -n6 : n6;
        int n8 = n7 * (n5 - n) / (n2 - n);
        return n6 < 0 ? n3 - n8 : n3 + n8;
    }

    public static final void renderLine(int n, int n2, int n3, int n4, float[] fArray) {
        int n5 = n4 - n2;
        int n6 = n3 - n;
        int n7 = n5 / n6;
        int n8 = n5 < 0 ? n7 - 1 : n7 + 1;
        int n9 = n;
        int n10 = n2;
        int n11 = 0;
        int n12 = (n5 < 0 ? -n5 : n5) - (n7 > 0 ? n7 * n6 : -n7 * n6);
        int n13 = n9;
        fArray[n13] = fArray[n13] * Floor.DB_STATIC_TABLE[n10];
        for (n9 = n + 1; n9 < n3; ++n9) {
            if ((n11 += n12) >= n6) {
                n11 -= n6;
                int n14 = n9;
                fArray[n14] = fArray[n14] * Floor.DB_STATIC_TABLE[n10 += n8];
                continue;
            }
            int n15 = n9;
            fArray[n15] = fArray[n15] * Floor.DB_STATIC_TABLE[n10 += n7];
        }
    }
}

