/*
 * Decompiled with CFR 0.152.
 */
package sound.javazoom.mp3spi;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import sound.javazoom.decoder.Bitstream;
import sound.javazoom.decoder.BitstreamException;
import sound.javazoom.decoder.Decoder;
import sound.javazoom.decoder.DecoderException;
import sound.javazoom.decoder.Header;
import sound.javazoom.decoder.Obuffer;
import sound.tritonus.TAsynchronousFilteredAudioInputStream;

public class DecodedMpegAudioInputStream
extends TAsynchronousFilteredAudioInputStream {
    private InputStream m_encodedStream;
    private Bitstream m_bitstream;
    private Decoder m_decoder;
    private Header m_header;
    private DMAISObuffer m_oBuffer;
    private long byteslength = -1L;
    private long currentByte = 0L;
    private int frameslength = -1;
    private long currentFrame = 0L;
    private int currentFramesize = 0;

    public DecodedMpegAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        super(audioFormat, -1L);
        try {
            this.byteslength = audioInputStream.available();
        }
        catch (IOException iOException) {
            this.byteslength = -1L;
        }
        this.m_encodedStream = audioInputStream;
        this.m_bitstream = new Bitstream(audioInputStream);
        this.m_decoder = new Decoder(null);
        this.m_oBuffer = new DMAISObuffer(audioFormat.getChannels());
        this.m_decoder.setOutputBuffer(this.m_oBuffer);
        try {
            this.m_header = this.m_bitstream.readFrame();
            if (this.m_header != null && this.frameslength == -1 && this.byteslength > 0L) {
                this.frameslength = this.m_header.max_number_of_frames((int)this.byteslength);
            }
        }
        catch (BitstreamException bitstreamException) {
            this.byteslength = -1L;
        }
    }

    @Override
    public void execute() {
        try {
            Header header = null;
            header = this.m_header == null ? this.m_bitstream.readFrame() : this.m_header;
            if (header == null) {
                this.getCircularBuffer().close();
                return;
            }
            ++this.currentFrame;
            this.currentFramesize = header.calculate_framesize();
            this.currentByte += (long)this.currentFramesize;
            this.m_decoder.decodeFrame(header, this.m_bitstream);
            this.m_bitstream.closeFrame();
            this.getCircularBuffer().write(this.m_oBuffer.getBuffer(), 0, this.m_oBuffer.getCurrentBufferSize());
            this.m_oBuffer.reset();
            if (this.m_header != null) {
                this.m_header = null;
            }
        }
        catch (BitstreamException bitstreamException) {
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
    }

    @Override
    public long skip(long l) {
        if (this.byteslength > 0L && this.frameslength > 0) {
            float f = (float)l * 1.0f / (float)this.byteslength * 1.0f;
            long l2 = this.skipFrames((long)(f * (float)this.frameslength));
            this.currentByte += l2;
            this.m_header = null;
            return l2;
        }
        return -1L;
    }

    public long skipFrames(long l) {
        int n = 0;
        int n2 = 0;
        try {
            int n3 = 0;
            while ((long)n3 < l) {
                Header header = this.m_bitstream.readFrame();
                if (header != null) {
                    int n4 = header.calculate_framesize();
                    n2 += n4;
                }
                this.m_bitstream.closeFrame();
                ++n;
                ++n3;
            }
        }
        catch (BitstreamException bitstreamException) {
            // empty catch block
        }
        this.currentFrame += (long)n;
        return n2;
    }

    private boolean isBigEndian() {
        return this.getFormat().isBigEndian();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.m_encodedStream.close();
    }

    private class DMAISObuffer
    extends Obuffer {
        private int m_nChannels;
        private byte[] m_abBuffer;
        private int[] m_anBufferPointers;
        private boolean m_bIsBigEndian;

        public DMAISObuffer(int n) {
            this.m_nChannels = n;
            this.m_abBuffer = new byte[2304 * n];
            this.m_anBufferPointers = new int[n];
            this.reset();
            this.m_bIsBigEndian = DecodedMpegAudioInputStream.this.isBigEndian();
        }

        @Override
        public void append(int n, short s) {
            byte by;
            byte by2;
            if (this.m_bIsBigEndian) {
                by2 = (byte)(s >>> 8 & 0xFF);
                by = (byte)(s & 0xFF);
            } else {
                by2 = (byte)(s & 0xFF);
                by = (byte)(s >>> 8 & 0xFF);
            }
            this.m_abBuffer[this.m_anBufferPointers[n]] = by2;
            this.m_abBuffer[this.m_anBufferPointers[n] + 1] = by;
            int n2 = n;
            this.m_anBufferPointers[n2] = this.m_anBufferPointers[n2] + this.m_nChannels * 2;
        }

        @Override
        public void set_stop_flag() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write_buffer(int n) {
        }

        @Override
        public void clear_buffer() {
        }

        public byte[] getBuffer() {
            return this.m_abBuffer;
        }

        public int getCurrentBufferSize() {
            return this.m_anBufferPointers[0];
        }

        public void reset() {
            for (int i = 0; i < this.m_nChannels; ++i) {
                this.m_anBufferPointers[i] = i * 2;
            }
        }
    }
}

