/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.fingerprint;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import sound.musicg.dsp.Resampler;
import sound.musicg.processor.TopManyPointsProcessorChain;
import sound.musicg.properties.FingerprintProperties;
import sound.musicg.wave.Wave;
import sound.musicg.wave.WaveHeader;
import sound.musicg.wave.extension.Spectrogram;

public class FingerprintManager {
    private FingerprintProperties fingerprintProperties = FingerprintProperties.getInstance();
    private int sampleSizePerFrame = this.fingerprintProperties.getSampleSizePerFrame();
    private int overlapFactor = this.fingerprintProperties.getOverlapFactor();
    private int numRobustPointsPerFrame = this.fingerprintProperties.getNumRobustPointsPerFrame();
    private int numFilterBanks = this.fingerprintProperties.getNumFilterBanks();

    public byte[] extractFingerprint(Wave wave) {
        int n;
        byte[] byArray = new byte[]{};
        Resampler resampler = new Resampler();
        int n2 = wave.getWaveHeader().getSampleRate();
        int n3 = this.fingerprintProperties.getSampleRate();
        byte[] byArray2 = resampler.reSample(wave.getBytes(), wave.getWaveHeader().getBitsPerSample(), n2, n3);
        WaveHeader waveHeader = wave.getWaveHeader();
        waveHeader.setSampleRate(n3);
        Wave wave2 = new Wave(waveHeader, byArray2);
        Spectrogram spectrogram = wave2.getSpectrogram(this.sampleSizePerFrame, this.overlapFactor);
        double[][] dArray = spectrogram.getNormalizedSpectrogramData();
        List<Integer>[] listArray = this.getRobustPointList(dArray);
        int n4 = listArray.length;
        int[][] nArray = new int[n4][this.numRobustPointsPerFrame];
        for (int i = 0; i < n4; ++i) {
            if (listArray[i].size() == this.numRobustPointsPerFrame) {
                Iterator<Integer> iterator = listArray[i].iterator();
                for (n = 0; n < this.numRobustPointsPerFrame; ++n) {
                    nArray[i][n] = iterator.next();
                }
                continue;
            }
            for (int j = 0; j < this.numRobustPointsPerFrame; ++j) {
                nArray[i][j] = -1;
            }
        }
        LinkedList<Byte> linkedList = new LinkedList<Byte>();
        for (int i = 0; i < n4; ++i) {
            for (n = 0; n < this.numRobustPointsPerFrame; ++n) {
                if (nArray[i][n] == -1) continue;
                int n5 = i;
                linkedList.add((byte)(n5 >> 8));
                linkedList.add((byte)n5);
                int n6 = nArray[i][n];
                linkedList.add((byte)(n6 >> 8));
                linkedList.add((byte)n6);
                int n7 = (int)(dArray[n5][n6] * 2.147483647E9);
                linkedList.add((byte)(n7 >> 24));
                linkedList.add((byte)(n7 >> 16));
                linkedList.add((byte)(n7 >> 8));
                linkedList.add((byte)n7);
            }
        }
        byArray = new byte[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        n = 0;
        while (iterator.hasNext()) {
            byArray[n++] = (Byte)iterator.next();
        }
        return byArray;
    }

    public byte[] getFingerprintFromFile(String string) {
        byte[] byArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byArray = this.getFingerprintFromInputStream(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    public byte[] getFingerprintFromInputStream(InputStream inputStream) {
        byte[] byArray = null;
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    public void saveFingerprintAsFile(byte[] byArray, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private List<Integer>[] getRobustPointList(double[][] dArray) {
        Object object;
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        int n3 = n2 / this.numFilterBanks;
        for (int i = 0; i < this.numFilterBanks; ++i) {
            double[][] dArray3 = new double[n][n3];
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n3; ++k) {
                    dArray3[j][k] = dArray[j][k + i * n3];
                }
            }
            TopManyPointsProcessorChain topManyPointsProcessorChain = new TopManyPointsProcessorChain(dArray3, 1);
            object = topManyPointsProcessorChain.getIntensities();
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n3; ++k) {
                    dArray2[j][k + i * n3] = object[j][k];
                }
            }
        }
        LinkedList<double[][]> linkedList = new LinkedList<double[][]>();
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[i].length; ++j) {
                if (!(dArray2[i][j] > 0.0)) continue;
                object = new int[]{i, j};
                linkedList.add((double[][])object);
            }
        }
        LinkedList[] linkedListArray = new LinkedList[dArray.length];
        for (int i = 0; i < linkedListArray.length; ++i) {
            linkedListArray[i] = new LinkedList();
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = (int[])iterator.next();
            linkedListArray[object[0]].add((int)object[1]);
        }
        return linkedListArray;
    }

    public static int getNumFrames(byte[] byArray) {
        if (byArray.length < 8) {
            return 0;
        }
        int n = ((byArray[byArray.length - 8] & 0xFF) << 8 | byArray[byArray.length - 7] & 0xFF) + 1;
        return n;
    }
}

