/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.fingerprint;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import sound.musicg.fingerprint.FingerprintManager;
import sound.musicg.math.quicksort.QuickSortIndexPreserved;
import sound.musicg.properties.FingerprintProperties;

public class PairManager {
    FingerprintProperties fingerprintProperties = FingerprintProperties.getInstance();
    private int numFilterBanks = this.fingerprintProperties.getNumFilterBanks();
    private int bandwidthPerBank = this.fingerprintProperties.getNumFrequencyUnits() / this.numFilterBanks;
    private int anchorPointsIntervalLength = this.fingerprintProperties.getAnchorPointsIntervalLength();
    private int numAnchorPointsPerInterval = this.fingerprintProperties.getNumAnchorPointsPerInterval();
    private int maxTargetZoneDistance = this.fingerprintProperties.getMaxTargetZoneDistance();
    private int numFrequencyUnits = this.fingerprintProperties.getNumFrequencyUnits();
    private int maxPairs;
    private boolean isReferencePairing;
    private HashMap<Integer, Boolean> stopPairTable = new HashMap();

    public PairManager() {
        this.maxPairs = this.fingerprintProperties.getRefMaxActivePairs();
        this.isReferencePairing = true;
    }

    public PairManager(boolean bl) {
        this.maxPairs = bl ? this.fingerprintProperties.getRefMaxActivePairs() : this.fingerprintProperties.getSampleMaxActivePairs();
        this.isReferencePairing = bl;
    }

    public HashMap<Integer, List<Integer>> getPair_PositionList_Table(byte[] byArray) {
        List<int[]> list = this.getPairPositionList(byArray);
        HashMap<Integer, List<Integer>> hashMap = new HashMap<Integer, List<Integer>>();
        for (int[] nArray : list) {
            if (hashMap.containsKey(nArray[0])) {
                hashMap.get(nArray[0]).add(nArray[1]);
                continue;
            }
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            linkedList.add(nArray[1]);
            hashMap.put(nArray[0], linkedList);
        }
        return hashMap;
    }

    private List<int[]> getPairPositionList(byte[] byArray) {
        int n = FingerprintManager.getNumFrames(byArray);
        byte[] byArray2 = new byte[n / this.anchorPointsIntervalLength + 1];
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        List<int[]> list = this.getSortedCoordinateList(byArray);
        for (int[] nArray : list) {
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = 0;
            Iterator<int[]> iterator = list.iterator();
            while (iterator.hasNext() && n4 < this.maxPairs && (!this.isReferencePairing || byArray2[n2 / this.anchorPointsIntervalLength] < this.numAnchorPointsPerInterval)) {
                int n5;
                int n6;
                int n7;
                int n8;
                int[] nArray2 = iterator.next();
                int n9 = nArray2[0];
                int n10 = nArray2[1];
                if (n2 == n9 && n3 == n10) continue;
                if (n9 >= n2) {
                    n8 = n9;
                    n7 = n10;
                    n6 = n2;
                    n5 = n3;
                } else {
                    n8 = n2;
                    n7 = n3;
                    n6 = n9;
                    n5 = n10;
                }
                if (n8 - n6 > this.maxTargetZoneDistance || n5 / this.bandwidthPerBank != n7 / this.bandwidthPerBank) continue;
                int n11 = (n8 - n6) * this.numFrequencyUnits * this.numFrequencyUnits + n7 * this.numFrequencyUnits + n5;
                if (!this.isReferencePairing && this.stopPairTable.containsKey(n11)) {
                    ++n4;
                    continue;
                }
                linkedList.add(new int[]{n11, n2});
                int n12 = n2 / this.anchorPointsIntervalLength;
                byArray2[n12] = (byte)(byArray2[n12] + 1);
                ++n4;
            }
        }
        return linkedList;
    }

    private List<int[]> getSortedCoordinateList(byte[] byArray) {
        int n = byArray.length / 8;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = i * 8 + 4;
            nArray[i] = n2 = (byArray[n3] & 0xFF) << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
        }
        QuickSortIndexPreserved quickSortIndexPreserved = new QuickSortIndexPreserved(nArray);
        int[] nArray2 = quickSortIndexPreserved.getSortIndexes();
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        for (int i = nArray2.length - 1; i >= 0; --i) {
            int n4 = nArray2[i] * 8;
            int n5 = (byArray[n4] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF;
            int n6 = (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
            linkedList.add(new int[]{n5, n6});
        }
        return linkedList;
    }

    public static byte[] pairHashcodeToBytes(int n) {
        return new byte[]{(byte)(n >> 8), (byte)n};
    }

    public static int pairBytesToHashcode(byte[] byArray) {
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }
}

