/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.processor;

import java.util.LinkedList;
import java.util.List;
import sound.musicg.processor.IntensityProcessor;
import sound.musicg.processor.RobustIntensityProcessor;

public class TopManyPointsProcessorChain {
    private double[][] intensities;
    List<IntensityProcessor> processorList = new LinkedList<IntensityProcessor>();

    public TopManyPointsProcessorChain(double[][] dArray, int n) {
        this.intensities = dArray;
        RobustIntensityProcessor robustIntensityProcessor = new RobustIntensityProcessor(dArray, n);
        this.processorList.add(robustIntensityProcessor);
        this.process();
    }

    private void process() {
        for (IntensityProcessor intensityProcessor : this.processorList) {
            intensityProcessor.execute();
            this.intensities = intensityProcessor.getIntensities();
        }
    }

    public double[][] getIntensities() {
        return this.intensities;
    }
}

