/*
 * Decompiled with CFR 0.152.
 */
package sound.musicg.wave.extension;

import sound.musicg.dsp.FastFourierTransform;
import sound.musicg.dsp.WindowFunction;
import sound.musicg.wave.Wave;

public class Spectrogram {
    public static final int SPECTROGRAM_DEFAULT_FFT_SAMPLE_SIZE = 1024;
    public static final int SPECTROGRAM_DEFAULT_OVERLAP_FACTOR = 0;
    private Wave wave;
    private double[][] spectrogram;
    private double[][] absoluteSpectrogram;
    private int fftSampleSize;
    private int overlapFactor;
    private int numFrames;
    private int framesPerSecond;
    private int numFrequencyUnit;
    private double unitFrequency;

    public Spectrogram(Wave wave) {
        this.wave = wave;
        this.fftSampleSize = 1024;
        this.overlapFactor = 0;
        this.buildSpectrogram();
    }

    public Spectrogram(Wave wave, int n, int n2) {
        this.wave = wave;
        if (Integer.bitCount(n) == 1) {
            this.fftSampleSize = n;
        } else {
            System.err.print("The input number must be a power of 2");
            this.fftSampleSize = 1024;
        }
        this.overlapFactor = n2;
        this.buildSpectrogram();
    }

    private void buildSpectrogram() {
        int n;
        short[] sArray = this.wave.getSampleAmplitudes();
        int n2 = sArray.length;
        int n3 = 0;
        if (this.overlapFactor > 1) {
            int n4 = n2 * this.overlapFactor;
            int n5 = this.fftSampleSize * (this.overlapFactor - 1) / this.overlapFactor;
            int n6 = this.fftSampleSize - 1;
            short[] sArray2 = new short[n4];
            n3 = 0;
            for (n = 0; n < sArray.length; ++n) {
                sArray2[n3++] = sArray[n];
                if (n3 % this.fftSampleSize != n6) continue;
                n -= n5;
            }
            n2 = n4;
            sArray = sArray2;
        }
        this.numFrames = n2 / this.fftSampleSize;
        this.framesPerSecond = (int)((float)this.numFrames / this.wave.length());
        WindowFunction windowFunction = new WindowFunction();
        windowFunction.setWindowType("Hamming");
        double[] dArray = windowFunction.generate(this.fftSampleSize);
        double[][] dArrayArray = new double[this.numFrames][];
        for (int i = 0; i < this.numFrames; ++i) {
            dArrayArray[i] = new double[this.fftSampleSize];
            n = i * this.fftSampleSize;
            for (int j = 0; j < this.fftSampleSize; ++j) {
                dArrayArray[i][j] = (double)sArray[n + j] * dArray[j];
            }
        }
        this.absoluteSpectrogram = new double[this.numFrames][];
        FastFourierTransform fastFourierTransform = new FastFourierTransform();
        for (n = 0; n < this.numFrames; ++n) {
            this.absoluteSpectrogram[n] = fastFourierTransform.getMagnitudes(dArrayArray[n]);
        }
        if (this.absoluteSpectrogram.length > 0) {
            this.numFrequencyUnit = this.absoluteSpectrogram[0].length;
            this.unitFrequency = (double)this.wave.getWaveHeader().getSampleRate() / 2.0 / (double)this.numFrequencyUnit;
            this.spectrogram = new double[this.numFrames][this.numFrequencyUnit];
            double d = Double.MIN_VALUE;
            double d2 = Double.MAX_VALUE;
            for (int i = 0; i < this.numFrames; ++i) {
                for (int j = 0; j < this.numFrequencyUnit; ++j) {
                    if (this.absoluteSpectrogram[i][j] > d) {
                        d = this.absoluteSpectrogram[i][j];
                        continue;
                    }
                    if (!(this.absoluteSpectrogram[i][j] < d2)) continue;
                    d2 = this.absoluteSpectrogram[i][j];
                }
            }
            double d3 = 1.0E-11f;
            if (d2 == 0.0) {
                d2 = d3;
            }
            double d4 = Math.log10(d / d2);
            for (int i = 0; i < this.numFrames; ++i) {
                for (int j = 0; j < this.numFrequencyUnit; ++j) {
                    this.spectrogram[i][j] = this.absoluteSpectrogram[i][j] < d3 ? 0.0 : Math.log10(this.absoluteSpectrogram[i][j] / d2) / d4;
                }
            }
        }
    }

    public double[][] getNormalizedSpectrogramData() {
        return this.spectrogram;
    }

    public double[][] getAbsoluteSpectrogramData() {
        return this.absoluteSpectrogram;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public int getNumFrequencyUnit() {
        return this.numFrequencyUnit;
    }

    public double getUnitFrequency() {
        return this.unitFrequency;
    }

    public int getFftSampleSize() {
        return this.fftSampleSize;
    }

    public int getOverlapFactor() {
        return this.overlapFactor;
    }
}

