/*
 * Decompiled with CFR 0.152.
 */
package sound.paulscode.libraries;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import sound.paulscode.Channel;
import sound.paulscode.FilenameURL;
import sound.paulscode.ICodec;
import sound.paulscode.Library;
import sound.paulscode.SoundBuffer;
import sound.paulscode.SoundSystem;
import sound.paulscode.SoundSystemConfig;
import sound.paulscode.SoundSystemException;
import sound.paulscode.Source;
import sound.paulscode.libraries.ChannelJavaSound;
import sound.paulscode.libraries.SourceJavaSound;

public class LibraryJavaSound
extends Library {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final int XXX = 0;
    private final int maxClipSize = 0x100000;
    private static Mixer myMixer = null;
    private static MixerRanking myMixerRanking = null;
    private static LibraryJavaSound instance = null;
    private static int minSampleRate = 4000;
    private static int maxSampleRate = 48000;
    private static int lineCount = 32;
    private static boolean useGainControl = true;
    private static boolean usePanControl = true;
    private static boolean useSampleRateControl = true;

    public LibraryJavaSound() throws SoundSystemException {
        instance = this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init() throws SoundSystemException {
        MixerRanking mixerRanking = null;
        if (myMixer == null) {
            for (Mixer.Info info : AudioSystem.getMixerInfo()) {
                if (!info.getName().equals("Java Sound Audio Engine")) continue;
                mixerRanking = new MixerRanking();
                try {
                    mixerRanking.rank(info);
                }
                catch (Exception exception) {
                    break;
                }
                if (mixerRanking.rank < 14) break;
                myMixer = AudioSystem.getMixer(info);
                LibraryJavaSound.mixerRanking(true, mixerRanking);
                break;
            }
            if (myMixer == null) {
                void var2_4;
                MixerRanking mixerRanking2 = mixerRanking;
                for (Mixer.Info info : AudioSystem.getMixerInfo()) {
                    mixerRanking = new MixerRanking();
                    try {
                        mixerRanking.rank(info);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (var2_4 != null && mixerRanking.rank <= var2_4.rank) continue;
                    MixerRanking mixerRanking3 = mixerRanking;
                }
                if (var2_4 == null) {
                    throw new Exception("No useable mixers found!", new MixerRanking());
                }
                try {
                    myMixer = AudioSystem.getMixer(var2_4.mixerInfo);
                    LibraryJavaSound.mixerRanking(true, (MixerRanking)var2_4);
                }
                catch (java.lang.Exception exception) {
                    throw new Exception("No useable mixers available!", new MixerRanking());
                }
            }
        }
        this.setMasterVolume(1.0f);
        this.message("JavaSound initialized.");
        super.init();
    }

    public static boolean libraryCompatible() {
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            if (!info.getName().equals("Java Sound Audio Engine")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Channel createChannel(int n) {
        return new ChannelJavaSound(n, myMixer);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        instance = null;
        myMixer = null;
        myMixerRanking = null;
    }

    @Override
    public boolean loadSound(FilenameURL filenameURL) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(filenameURL == null, "Filename/URL not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(filenameURL.getFilename()) != null) {
            return true;
        }
        ICodec iCodec = SoundSystemConfig.getCodec(filenameURL.getFilename());
        if (this.errorCheck(iCodec == null, "No codec found for file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        URL uRL = filenameURL.getURL();
        if (this.errorCheck(uRL == null, "Unable to open file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.initialize(uRL);
        SoundBuffer soundBuffer = iCodec.readAll();
        iCodec.cleanup();
        iCodec = null;
        if (soundBuffer != null) {
            this.bufferMap.put(filenameURL.getFilename(), soundBuffer);
        } else {
            this.errorMessage("Sound buffer null in method 'loadSound'");
        }
        return true;
    }

    @Override
    public boolean loadSound(SoundBuffer soundBuffer, String string) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(string == null, "Identifier not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(string) != null) {
            return true;
        }
        if (soundBuffer != null) {
            this.bufferMap.put(string, soundBuffer);
        } else {
            this.errorMessage("Sound buffer null in method 'loadSound'");
        }
        return true;
    }

    @Override
    public void setMasterVolume(float f) {
        super.setMasterVolume(f);
        Set set = this.sourceMap.keySet();
        for (String string : set) {
            Source source = (Source)this.sourceMap.get(string);
            if (source == null) continue;
            source.positionChanged();
        }
    }

    @Override
    public void newSource(boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, float f, float f2, float f3, int n, float f4) {
        SoundBuffer soundBuffer = null;
        if (!bl2) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        if (!bl2 && soundBuffer != null) {
            soundBuffer.trimData(0x100000);
        }
        this.sourceMap.put(string, new SourceJavaSound(this.listener, bl, bl2, bl3, string, filenameURL, soundBuffer, f, f2, f3, n, f4, false));
    }

    @Override
    public void rawDataStream(AudioFormat audioFormat, boolean bl, String string, float f, float f2, float f3, int n, float f4) {
        this.sourceMap.put(string, new SourceJavaSound(this.listener, audioFormat, bl, string, f, f2, f3, n, f4));
    }

    @Override
    public void quickPlay(boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, float f, float f2, float f3, int n, float f4, boolean bl4) {
        SoundBuffer soundBuffer = null;
        if (!bl2) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        if (!bl2 && soundBuffer != null) {
            soundBuffer.trimData(0x100000);
        }
        this.sourceMap.put(string, new SourceJavaSound(this.listener, bl, bl2, bl3, string, filenameURL, soundBuffer, f, f2, f3, n, f4, bl4));
    }

    @Override
    public void copySources(HashMap<String, Source> hashMap) {
        if (hashMap == null) {
            return;
        }
        Set<String> set = hashMap.keySet();
        Iterator<String> iterator = set.iterator();
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'copySources'");
        }
        this.sourceMap.clear();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Source source = hashMap.get(string);
            if (source == null) continue;
            SoundBuffer soundBuffer = null;
            if (!source.toStream) {
                this.loadSound(source.filenameURL);
                soundBuffer = (SoundBuffer)this.bufferMap.get(source.filenameURL.getFilename());
            }
            if (!source.toStream && soundBuffer != null) {
                soundBuffer.trimData(0x100000);
            }
            if (!source.toStream && soundBuffer == null) continue;
            this.sourceMap.put(string, new SourceJavaSound(this.listener, source, soundBuffer));
        }
    }

    @Override
    public void setListenerVelocity(float f, float f2, float f3) {
        super.setListenerVelocity(f, f2, f3);
        this.listenerMoved();
    }

    @Override
    public void dopplerChanged() {
        super.dopplerChanged();
        this.listenerMoved();
    }

    public static Mixer getMixer() {
        return LibraryJavaSound.mixer(false, null);
    }

    public static void setMixer(Mixer mixer) throws SoundSystemException {
        LibraryJavaSound.mixer(true, mixer);
        SoundSystemException soundSystemException = SoundSystem.getLastException();
        SoundSystem.setException(null);
        if (soundSystemException != null) {
            throw soundSystemException;
        }
    }

    private static synchronized Mixer mixer(boolean bl, Mixer mixer) {
        if (bl) {
            if (mixer == null) {
                return myMixer;
            }
            MixerRanking mixerRanking = new MixerRanking();
            try {
                mixerRanking.rank(mixer.getMixerInfo());
            }
            catch (Exception exception) {
                SoundSystemConfig.getLogger().printStackTrace(exception, 1);
                SoundSystem.setException(exception);
            }
            myMixer = mixer;
            LibraryJavaSound.mixerRanking(true, mixerRanking);
            if (instance != null) {
                ChannelJavaSound channelJavaSound;
                ListIterator listIterator = LibraryJavaSound.instance.normalChannels.listIterator();
                SoundSystem.setException(null);
                while (listIterator.hasNext()) {
                    channelJavaSound = (ChannelJavaSound)listIterator.next();
                    channelJavaSound.newMixer(mixer);
                }
                listIterator = LibraryJavaSound.instance.streamingChannels.listIterator();
                while (listIterator.hasNext()) {
                    channelJavaSound = (ChannelJavaSound)listIterator.next();
                    channelJavaSound.newMixer(mixer);
                }
            }
        }
        return myMixer;
    }

    public static MixerRanking getMixerRanking() {
        return LibraryJavaSound.mixerRanking(false, null);
    }

    private static synchronized MixerRanking mixerRanking(boolean bl, MixerRanking mixerRanking) {
        if (bl) {
            myMixerRanking = mixerRanking;
        }
        return myMixerRanking;
    }

    public static void setMinSampleRate(int n) {
        LibraryJavaSound.minSampleRate(true, n);
    }

    private static synchronized int minSampleRate(boolean bl, int n) {
        if (bl) {
            minSampleRate = n;
        }
        return minSampleRate;
    }

    public static void setMaxSampleRate(int n) {
        LibraryJavaSound.maxSampleRate(true, n);
    }

    private static synchronized int maxSampleRate(boolean bl, int n) {
        if (bl) {
            maxSampleRate = n;
        }
        return maxSampleRate;
    }

    public static void setLineCount(int n) {
        LibraryJavaSound.lineCount(true, n);
    }

    private static synchronized int lineCount(boolean bl, int n) {
        if (bl) {
            lineCount = n;
        }
        return lineCount;
    }

    public static void useGainControl(boolean bl) {
        LibraryJavaSound.useGainControl(true, bl);
    }

    private static synchronized boolean useGainControl(boolean bl, boolean bl2) {
        if (bl) {
            useGainControl = bl2;
        }
        return useGainControl;
    }

    public static void usePanControl(boolean bl) {
        LibraryJavaSound.usePanControl(true, bl);
    }

    private static synchronized boolean usePanControl(boolean bl, boolean bl2) {
        if (bl) {
            usePanControl = bl2;
        }
        return usePanControl;
    }

    public static void useSampleRateControl(boolean bl) {
        LibraryJavaSound.useSampleRateControl(true, bl);
    }

    private static synchronized boolean useSampleRateControl(boolean bl, boolean bl2) {
        if (bl) {
            useSampleRateControl = bl2;
        }
        return useSampleRateControl;
    }

    public static String getTitle() {
        return "Java Sound";
    }

    public static String getDescription() {
        return "The Java Sound API.  For more information, see http://java.sun.com/products/java-media/sound/";
    }

    @Override
    public String getClassName() {
        return "LibraryJavaSound";
    }

    public static class Exception
    extends SoundSystemException {
        public static final int MIXER_PROBLEM = 101;
        public static MixerRanking mixerRanking = null;

        public Exception(String string) {
            super(string);
        }

        public Exception(String string, int n) {
            super(string, n);
        }

        public Exception(String string, MixerRanking mixerRanking) {
            super(string, 101);
            Exception.mixerRanking = mixerRanking;
        }
    }

    public static class MixerRanking {
        public static final int HIGH = 1;
        public static final int MEDIUM = 2;
        public static final int LOW = 3;
        public static final int NONE = 4;
        public static int MIXER_EXISTS_PRIORITY = 1;
        public static int MIN_SAMPLE_RATE_PRIORITY = 1;
        public static int MAX_SAMPLE_RATE_PRIORITY = 1;
        public static int LINE_COUNT_PRIORITY = 1;
        public static int GAIN_CONTROL_PRIORITY = 2;
        public static int PAN_CONTROL_PRIORITY = 2;
        public static int SAMPLE_RATE_CONTROL_PRIORITY = 3;
        public Mixer.Info mixerInfo = null;
        public int rank = 0;
        public boolean mixerExists = false;
        public boolean minSampleRateOK = false;
        public boolean maxSampleRateOK = false;
        public boolean lineCountOK = false;
        public boolean gainControlOK = false;
        public boolean panControlOK = false;
        public boolean sampleRateControlOK = false;
        public int minSampleRatePossible = -1;
        public int maxSampleRatePossible = -1;
        public int maxLinesPossible = 0;

        public MixerRanking() {
        }

        public MixerRanking(Mixer.Info info, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
            this.mixerInfo = info;
            this.rank = n;
            this.mixerExists = bl;
            this.minSampleRateOK = bl2;
            this.maxSampleRateOK = bl3;
            this.lineCountOK = bl4;
            this.gainControlOK = bl5;
            this.panControlOK = bl6;
            this.sampleRateControlOK = bl7;
        }

        public void rank(Mixer.Info info) throws Exception {
            SourceDataLine[] sourceDataLineArray;
            int n;
            int n2;
            int n3;
            DataLine.Info info2;
            AudioFormat audioFormat;
            Mixer mixer;
            if (info == null) {
                throw new Exception("No Mixer info specified in method 'MixerRanking.rank'", this);
            }
            this.mixerInfo = info;
            try {
                mixer = AudioSystem.getMixer(this.mixerInfo);
            }
            catch (java.lang.Exception exception) {
                throw new Exception("Unable to acquire the specified Mixer in method 'MixerRanking.rank'", this);
            }
            if (mixer == null) {
                throw new Exception("Unable to acquire the specified Mixer in method 'MixerRanking.rank'", this);
            }
            this.mixerExists = true;
            try {
                audioFormat = new AudioFormat(LibraryJavaSound.minSampleRate(false, 0), 16, 2, true, false);
                info2 = new DataLine.Info(SourceDataLine.class, audioFormat);
            }
            catch (java.lang.Exception exception) {
                throw new Exception("Invalid minimum sample-rate specified in method 'MixerRanking.rank'", this);
            }
            if (!AudioSystem.isLineSupported(info2)) {
                if (MIN_SAMPLE_RATE_PRIORITY == 1) {
                    throw new Exception("Specified minimum sample-rate not possible for Mixer '" + this.mixerInfo.getName() + "'", this);
                }
            } else {
                this.minSampleRateOK = true;
            }
            try {
                audioFormat = new AudioFormat(LibraryJavaSound.maxSampleRate(false, 0), 16, 2, true, false);
                info2 = new DataLine.Info(SourceDataLine.class, audioFormat);
            }
            catch (java.lang.Exception exception) {
                throw new Exception("Invalid maximum sample-rate specified in method 'MixerRanking.rank'", this);
            }
            if (!AudioSystem.isLineSupported(info2)) {
                if (MAX_SAMPLE_RATE_PRIORITY == 1) {
                    throw new Exception("Specified maximum sample-rate not possible for Mixer '" + this.mixerInfo.getName() + "'", this);
                }
            } else {
                this.maxSampleRateOK = true;
            }
            if (this.minSampleRateOK) {
                this.minSampleRatePossible = LibraryJavaSound.minSampleRate(false, 0);
            } else {
                n3 = LibraryJavaSound.minSampleRate(false, 0);
                n2 = LibraryJavaSound.maxSampleRate(false, 0);
                while (n2 - n3 > 1) {
                    n = n3 + (n2 - n3) / 2;
                    audioFormat = new AudioFormat(n, 16, 2, true, false);
                    info2 = new DataLine.Info(SourceDataLine.class, audioFormat);
                    if (AudioSystem.isLineSupported(info2)) {
                        this.minSampleRatePossible = n;
                        n2 = n;
                        continue;
                    }
                    n3 = n;
                }
            }
            if (this.maxSampleRateOK) {
                this.maxSampleRatePossible = LibraryJavaSound.maxSampleRate(false, 0);
            } else if (this.minSampleRatePossible != -1) {
                n2 = LibraryJavaSound.maxSampleRate(false, 0);
                n3 = this.minSampleRatePossible;
                while (n2 - n3 > 1) {
                    n = n3 + (n2 - n3) / 2;
                    audioFormat = new AudioFormat(n, 16, 2, true, false);
                    info2 = new DataLine.Info(SourceDataLine.class, audioFormat);
                    if (AudioSystem.isLineSupported(info2)) {
                        this.maxSampleRatePossible = n;
                        n3 = n;
                        continue;
                    }
                    n2 = n;
                }
            }
            if (this.minSampleRatePossible == -1 || this.maxSampleRatePossible == -1) {
                throw new Exception("No possible sample-rate found for Mixer '" + this.mixerInfo.getName() + "'", this);
            }
            audioFormat = new AudioFormat(this.minSampleRatePossible, 16, 2, true, false);
            Clip clip = null;
            try {
                sourceDataLineArray = new DataLine.Info(Clip.class, audioFormat);
                clip = (Clip)mixer.getLine((Line.Info)sourceDataLineArray);
                byte[] byArray = new byte[10];
                clip.open(audioFormat, byArray, 0, byArray.length);
            }
            catch (java.lang.Exception exception) {
                throw new Exception("Unable to attach an actual audio buffer to an actual Clip... Mixer '" + this.mixerInfo.getName() + "' is unuseable.", this);
            }
            this.maxLinesPossible = 1;
            info2 = new DataLine.Info(SourceDataLine.class, audioFormat);
            sourceDataLineArray = new SourceDataLine[LibraryJavaSound.lineCount(false, 0) - 1];
            boolean bl = false;
            for (int i = 1; i < sourceDataLineArray.length + 1; ++i) {
                try {
                    sourceDataLineArray[i - 1] = (SourceDataLine)mixer.getLine(info2);
                }
                catch (java.lang.Exception exception) {
                    if (i == 0) {
                        throw new Exception("No output lines possible for Mixer '" + this.mixerInfo.getName() + "'", this);
                    }
                    if (LINE_COUNT_PRIORITY != 1) break;
                    throw new Exception("Specified maximum number of lines not possible for Mixer '" + this.mixerInfo.getName() + "'", this);
                }
                this.maxLinesPossible = i + 1;
            }
            try {
                clip.close();
            }
            catch (java.lang.Exception exception) {
                // empty catch block
            }
            clip = null;
            if (this.maxLinesPossible == LibraryJavaSound.lineCount(false, 0)) {
                this.lineCountOK = true;
            }
            if (!LibraryJavaSound.useGainControl(false, false)) {
                GAIN_CONTROL_PRIORITY = 4;
            } else if (!sourceDataLineArray[0].isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                if (GAIN_CONTROL_PRIORITY == 1) {
                    throw new Exception("Gain control not available for Mixer '" + this.mixerInfo.getName() + "'", this);
                }
            } else {
                this.gainControlOK = true;
            }
            if (!LibraryJavaSound.usePanControl(false, false)) {
                PAN_CONTROL_PRIORITY = 4;
            } else if (!sourceDataLineArray[0].isControlSupported(FloatControl.Type.PAN)) {
                if (PAN_CONTROL_PRIORITY == 1) {
                    throw new Exception("Pan control not available for Mixer '" + this.mixerInfo.getName() + "'", this);
                }
            } else {
                this.panControlOK = true;
            }
            if (!LibraryJavaSound.useSampleRateControl(false, false)) {
                SAMPLE_RATE_CONTROL_PRIORITY = 4;
            } else if (!sourceDataLineArray[0].isControlSupported(FloatControl.Type.SAMPLE_RATE)) {
                if (SAMPLE_RATE_CONTROL_PRIORITY == 1) {
                    throw new Exception("Sample-rate control not available for Mixer '" + this.mixerInfo.getName() + "'", this);
                }
            } else {
                this.sampleRateControlOK = true;
            }
            this.rank += this.getRankValue(this.mixerExists, MIXER_EXISTS_PRIORITY);
            this.rank += this.getRankValue(this.minSampleRateOK, MIN_SAMPLE_RATE_PRIORITY);
            this.rank += this.getRankValue(this.maxSampleRateOK, MAX_SAMPLE_RATE_PRIORITY);
            this.rank += this.getRankValue(this.lineCountOK, LINE_COUNT_PRIORITY);
            this.rank += this.getRankValue(this.gainControlOK, GAIN_CONTROL_PRIORITY);
            this.rank += this.getRankValue(this.panControlOK, PAN_CONTROL_PRIORITY);
            this.rank += this.getRankValue(this.sampleRateControlOK, SAMPLE_RATE_CONTROL_PRIORITY);
            mixer = null;
            audioFormat = null;
            info2 = null;
            sourceDataLineArray = null;
        }

        private int getRankValue(boolean bl, int n) {
            if (bl) {
                return 2;
            }
            if (n == 4) {
                return 2;
            }
            if (n == 3) {
                return 1;
            }
            return 0;
        }
    }
}

