/*
 * Decompiled with CFR 0.152.
 */
package sound;

import br.com.etyllica.core.loader.LoaderImpl;
import sound.paulscode.Library;
import sound.paulscode.SoundSystem;
import sound.paulscode.SoundSystemConfig;
import sound.paulscode.SoundSystemException;
import sound.paulscode.codecs.CodecJLayerMP3;
import sound.paulscode.codecs.CodecJOrbis;
import sound.paulscode.codecs.CodecWav;
import sound.paulscode.libraries.LibraryJavaSound;

public class MultimediaLoader
extends LoaderImpl {
    private SoundSystem mySoundSystem;
    private static MultimediaLoader instance = null;

    public static MultimediaLoader getInstance() {
        if (instance == null) {
            instance = new MultimediaLoader();
        }
        return instance;
    }

    public MultimediaLoader() {
        this.folder = "assets/sounds/";
        try {
            SoundSystemConfig.setCodec("wav", CodecWav.class);
            SoundSystemConfig.setCodec("ogg", CodecJOrbis.class);
            SoundSystemConfig.setCodec("mp3", CodecJLayerMP3.class);
            SoundSystemConfig.addLibrary(LibraryJavaSound.class);
            SoundSystemConfig.setSoundFilesPackage(this.folder);
            this.mySoundSystem = new SoundSystem(LibraryJavaSound.class);
        }
        catch (SoundSystemException soundSystemException) {
            System.err.println("Error on " + ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    public void setSoundLibrary(Class<? extends Library> clazz) {
        try {
            this.mySoundSystem = new SoundSystem(clazz);
        }
        catch (SoundSystemException soundSystemException) {
            soundSystemException.printStackTrace();
        }
    }

    public boolean isPlaying(String string) {
        return this.mySoundSystem.playing(string);
    }

    public void loadMusic(String string) {
        this.mySoundSystem.loadSound(string);
    }

    public void playMusic(String string, boolean bl) {
        this.mySoundSystem.backgroundMusic(string, string, bl);
        this.mySoundSystem.play(string);
    }

    public void loadSound(String string) {
        this.mySoundSystem.loadSound(string);
    }

    public void playSound(String string) {
        this.mySoundSystem.quickPlay(false, string, false, 0.0f, 0.0f, 0.0f, 0, SoundSystemConfig.getDefaultRolloff());
    }

    public void playMusicStream(String string) {
        this.playMusicStream(string, false);
    }

    public void playMusicStream(String string, boolean bl) {
        this.mySoundSystem.backgroundMusic(string, string, bl);
        this.mySoundSystem.play(string);
    }
}

