/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.ogg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import sound.jarnbjo.ogg.EndOfOggStreamException;
import sound.jarnbjo.ogg.LogicalOggStream;
import sound.jarnbjo.ogg.OggFormatException;
import sound.jarnbjo.ogg.OggPage;
import sound.jarnbjo.ogg.PhysicalOggStream;

public class LogicalOggStreamImpl
implements LogicalOggStream {
    private PhysicalOggStream source;
    private int serialNumber;
    private ArrayList pageNumberMapping = new ArrayList();
    private ArrayList granulePositions = new ArrayList();
    private int pageIndex = 0;
    private OggPage currentPage;
    private int currentSegmentIndex;
    private boolean open = true;
    private String format = "application/octet-stream";

    public LogicalOggStreamImpl(PhysicalOggStream physicalOggStream, int n) {
        this.source = physicalOggStream;
        this.serialNumber = n;
    }

    public void addPageNumberMapping(int n) {
        this.pageNumberMapping.add(new Integer(n));
    }

    public void addGranulePosition(long l) {
        this.granulePositions.add(new Long(l));
    }

    @Override
    public synchronized void reset() throws OggFormatException, IOException {
        this.currentPage = null;
        this.currentSegmentIndex = 0;
        this.pageIndex = 0;
    }

    @Override
    public synchronized OggPage getNextOggPage() throws EndOfOggStreamException, OggFormatException, IOException {
        this.currentPage = this.source.isSeekable() ? this.source.getOggPage((Integer)this.pageNumberMapping.get(this.pageIndex++)) : this.source.getOggPage(-1);
        return this.currentPage;
    }

    @Override
    public synchronized byte[] getNextOggPacket() throws EndOfOggStreamException, OggFormatException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        if (this.currentPage == null) {
            this.currentPage = this.getNextOggPage();
        }
        do {
            if (this.currentSegmentIndex >= this.currentPage.getSegmentOffsets().length) {
                this.currentSegmentIndex = 0;
                if (!this.currentPage.isEos()) {
                    if (this.source.isSeekable() && this.pageNumberMapping.size() <= this.pageIndex) {
                        while (this.pageNumberMapping.size() <= this.pageIndex + 10) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    this.currentPage = this.getNextOggPage();
                    if (byteArrayOutputStream.size() == 0 && this.currentPage.isContinued()) {
                        boolean bl = false;
                        while (!bl) {
                            if (this.currentPage.getSegmentLengths()[this.currentSegmentIndex++] != 255) {
                                bl = true;
                            }
                            if (this.currentSegmentIndex <= this.currentPage.getSegmentTable().length) continue;
                            this.currentPage = this.source.getOggPage((Integer)this.pageNumberMapping.get(this.pageIndex++));
                        }
                    }
                } else {
                    throw new EndOfOggStreamException();
                }
            }
            n = this.currentPage.getSegmentLengths()[this.currentSegmentIndex];
            byteArrayOutputStream.write(this.currentPage.getData(), this.currentPage.getSegmentOffsets()[this.currentSegmentIndex], n);
            ++this.currentSegmentIndex;
        } while (n == 255);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    @Override
    public long getMaximumGranulePosition() {
        Long l = (Long)this.granulePositions.get(this.granulePositions.size() - 1);
        return l;
    }

    @Override
    public synchronized long getTime() {
        return this.currentPage != null ? this.currentPage.getAbsoluteGranulePosition() : -1L;
    }

    @Override
    public synchronized void setTime(long l) throws IOException {
        Long l2;
        int n = 0;
        for (n = 0; n < this.granulePositions.size() && (l2 = (Long)this.granulePositions.get(n)) <= l; ++n) {
        }
        this.pageIndex = n;
        this.currentPage = this.source.getOggPage((Integer)this.pageNumberMapping.get(this.pageIndex++));
        this.currentSegmentIndex = 0;
        int n2 = 0;
        do {
            if (this.currentSegmentIndex >= this.currentPage.getSegmentOffsets().length) {
                this.currentSegmentIndex = 0;
                if (this.pageIndex >= this.pageNumberMapping.size()) {
                    throw new EndOfOggStreamException();
                }
                this.currentPage = this.source.getOggPage((Integer)this.pageNumberMapping.get(this.pageIndex++));
            }
            n2 = this.currentPage.getSegmentLengths()[this.currentSegmentIndex];
            ++this.currentSegmentIndex;
        } while (n2 == 255);
    }

    public void checkFormat(OggPage oggPage) {
        byte[] byArray = oggPage.getData();
        if (byArray.length >= 7 && byArray[1] == 118 && byArray[2] == 111 && byArray[3] == 114 && byArray[4] == 98 && byArray[5] == 105 && byArray[6] == 115) {
            this.format = "audio/x-vorbis";
        } else if (byArray.length >= 7 && byArray[1] == 116 && byArray[2] == 104 && byArray[3] == 101 && byArray[4] == 111 && byArray[5] == 114 && byArray[6] == 97) {
            this.format = "video/x-theora";
        } else if (byArray.length == 4 && byArray[0] == 102 && byArray[1] == 76 && byArray[2] == 97 && byArray[3] == 67) {
            this.format = "audio/x-flac";
        }
    }

    @Override
    public String getFormat() {
        return this.format;
    }
}

