/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.ogg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import sound.jarnbjo.ogg.EndOfOggStreamException;
import sound.jarnbjo.ogg.OggFormatException;
import sound.jarnbjo.util.io.ByteArrayBitInputStream;

public class OggPage {
    private int version;
    private boolean continued;
    private boolean bos;
    private boolean eos;
    private long absoluteGranulePosition;
    private int streamSerialNumber;
    private int pageSequenceNumber;
    private int pageCheckSum;
    private int[] segmentOffsets;
    private int[] segmentLengths;
    private int totalLength;
    private byte[] header;
    private byte[] segmentTable;
    private byte[] data;

    protected OggPage() {
    }

    private OggPage(int n, boolean bl, boolean bl2, boolean bl3, long l, int n2, int n3, int n4, int[] nArray, int[] nArray2, int n5, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.version = n;
        this.continued = bl;
        this.bos = bl2;
        this.eos = bl3;
        this.absoluteGranulePosition = l;
        this.streamSerialNumber = n2;
        this.pageSequenceNumber = n3;
        this.pageCheckSum = n4;
        this.segmentOffsets = nArray;
        this.segmentLengths = nArray2;
        this.totalLength = n5;
        this.header = byArray;
        this.segmentTable = byArray2;
        this.data = byArray3;
    }

    public static OggPage create(RandomAccessFile randomAccessFile) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create(randomAccessFile, false);
    }

    public static OggPage create(RandomAccessFile randomAccessFile, boolean bl) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create((Object)randomAccessFile, bl);
    }

    public static OggPage create(InputStream inputStream) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create(inputStream, false);
    }

    public static OggPage create(InputStream inputStream, boolean bl) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create((Object)inputStream, bl);
    }

    public static OggPage create(byte[] byArray) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create(byArray, false);
    }

    public static OggPage create(byte[] byArray, boolean bl) throws IOException, EndOfOggStreamException, OggFormatException {
        return OggPage.create((Object)byArray, bl);
    }

    private static OggPage create(Object object, boolean bl) throws IOException, EndOfOggStreamException, OggFormatException {
        try {
            char c;
            char c2;
            char c3;
            char c4;
            Object object2;
            int n = 27;
            byte[] byArray = new byte[27];
            if (object instanceof RandomAccessFile) {
                object2 = (RandomAccessFile)object;
                if (((RandomAccessFile)object2).getFilePointer() == ((RandomAccessFile)object2).length()) {
                    return null;
                }
                ((RandomAccessFile)object2).readFully(byArray);
            } else if (object instanceof InputStream) {
                OggPage.readFully((InputStream)object, byArray);
            } else if (object instanceof byte[]) {
                System.arraycopy((byte[])object, 0, byArray, 0, 27);
            }
            object2 = new ByteArrayBitInputStream(byArray);
            int n2 = object2.getInt(32);
            if (n2 != 1399285583) {
                String string = Integer.toHexString(n2);
                while (string.length() < 8) {
                    string = "0" + string;
                }
                string = string.substring(6, 8) + string.substring(4, 6) + string.substring(2, 4) + string.substring(0, 2);
                c4 = (char)Integer.valueOf(string.substring(0, 2), 16).intValue();
                c3 = (char)Integer.valueOf(string.substring(2, 4), 16).intValue();
                c2 = (char)Integer.valueOf(string.substring(4, 6), 16).intValue();
                c = (char)Integer.valueOf(string.substring(6, 8), 16).intValue();
                System.out.println("Ogg packet header is 0x" + string + " (" + c4 + c3 + c2 + c + "), should be 0x4f676753 (OggS)");
            }
            int n3 = object2.getInt(8);
            c4 = (char)object2.getInt(8);
            c3 = (c4 & 1) != 0 ? (char)'\u0001' : '\u0000';
            c2 = (c4 & 2) != 0 ? (char)'\u0001' : '\u0000';
            c = (c4 & 4) != 0 ? (char)'\u0001' : '\u0000';
            long l = object2.getLong(64);
            int n4 = object2.getInt(32);
            int n5 = object2.getInt(32);
            int n6 = object2.getInt(32);
            int n7 = object2.getInt(8);
            int[] nArray = new int[n7];
            int[] nArray2 = new int[n7];
            int n8 = 0;
            byte[] byArray2 = new byte[n7];
            byte[] byArray3 = new byte[1];
            for (int i = 0; i < n7; ++i) {
                int n9 = 0;
                if (object instanceof RandomAccessFile) {
                    n9 = ((RandomAccessFile)object).readByte() & 0xFF;
                } else if (object instanceof InputStream) {
                    n9 = ((InputStream)object).read();
                } else if (object instanceof byte[]) {
                    n9 = ((byte[])object)[n++];
                    n9 &= 0xFF;
                }
                byArray2[i] = (byte)n9;
                nArray2[i] = n9;
                nArray[i] = n8;
                n8 += n9;
            }
            byte[] byArray4 = null;
            if (!bl) {
                byArray4 = new byte[n8];
                if (object instanceof RandomAccessFile) {
                    ((RandomAccessFile)object).readFully(byArray4);
                } else if (object instanceof InputStream) {
                    OggPage.readFully((InputStream)object, byArray4);
                } else if (object instanceof byte[]) {
                    System.arraycopy(object, n, byArray4, 0, n8);
                }
            }
            return new OggPage(n3, c3 != '\u0000', c2 != '\u0000', c != '\u0000', l, n4, n5, n6, nArray, nArray2, n8, byArray, byArray2, byArray4);
        }
        catch (EOFException eOFException) {
            throw new EndOfOggStreamException();
        }
    }

    private static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = inputStream.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            throw new EndOfOggStreamException();
        }
    }

    public long getAbsoluteGranulePosition() {
        return this.absoluteGranulePosition;
    }

    public int getStreamSerialNumber() {
        return this.streamSerialNumber;
    }

    public int getPageSequenceNumber() {
        return this.pageSequenceNumber;
    }

    public int getPageCheckSum() {
        return this.pageCheckSum;
    }

    public int getTotalLength() {
        if (this.data != null) {
            return 27 + this.segmentTable.length + this.data.length;
        }
        return this.totalLength;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getSegmentTable() {
        return this.segmentTable;
    }

    public int[] getSegmentOffsets() {
        return this.segmentOffsets;
    }

    public int[] getSegmentLengths() {
        return this.segmentLengths;
    }

    public boolean isContinued() {
        return this.continued;
    }

    public boolean isFresh() {
        return !this.continued;
    }

    public boolean isBos() {
        return this.bos;
    }

    public boolean isEos() {
        return this.eos;
    }
}

