/*
 * Decompiled with CFR 0.152.
 */
package sound.jarnbjo.ogg;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import sound.jarnbjo.ogg.EndOfOggStreamException;
import sound.jarnbjo.ogg.LogicalOggStream;
import sound.jarnbjo.ogg.LogicalOggStreamImpl;
import sound.jarnbjo.ogg.OggFormatException;
import sound.jarnbjo.ogg.OggPage;
import sound.jarnbjo.ogg.PhysicalOggStream;

public class UncachedUrlStream
implements PhysicalOggStream {
    private boolean closed = false;
    private URLConnection source;
    private InputStream sourceStream;
    private Object drainLock = new Object();
    private LinkedList<OggPage> pageCache = new LinkedList();
    private long numberOfSamples = -1L;
    private Map<Integer, LogicalOggStream> logicalStreams = new HashMap<Integer, LogicalOggStream>();
    private LoaderThread loaderThread;
    private static final int PAGECACHE_SIZE = 10;

    public UncachedUrlStream(URL uRL) throws OggFormatException, IOException {
        this.source = uRL.openConnection();
        this.sourceStream = this.source.getInputStream();
        this.loaderThread = new LoaderThread(this.sourceStream, this.pageCache);
        new Thread(this.loaderThread).start();
        while (!this.loaderThread.isBosDone() || this.pageCache.size() < 10) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.sourceStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OggPage getOggPage(int n) throws IOException {
        while (this.pageCache.size() == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Object object = this.drainLock;
        synchronized (object) {
            return this.pageCache.removeFirst();
        }
    }

    private LogicalOggStream getLogicalStream(int n) {
        return this.logicalStreams.get(new Integer(n));
    }

    @Override
    public void setTime(long l) throws IOException {
        throw new UnsupportedOperationException("Method not supported by this class");
    }

    @Override
    public boolean isSeekable() {
        return false;
    }

    public class LoaderThread
    implements Runnable {
        private InputStream source;
        private LinkedList<OggPage> pageCache;
        private RandomAccessFile drain;
        private byte[] memoryCache;
        private boolean bosDone = false;
        private int pageNumber;

        public LoaderThread(InputStream inputStream, LinkedList<OggPage> linkedList) {
            this.source = inputStream;
            this.pageCache = linkedList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean bl = false;
                byte[] byArray = new byte[8192];
                while (!bl) {
                    OggPage oggPage = OggPage.create(this.source);
                    Object object = UncachedUrlStream.this.drainLock;
                    synchronized (object) {
                        this.pageCache.add(oggPage);
                    }
                    if (!oggPage.isBos()) {
                        this.bosDone = true;
                    }
                    if (oggPage.isEos()) {
                        bl = true;
                    }
                    if ((object = (LogicalOggStreamImpl)UncachedUrlStream.this.getLogicalStream(oggPage.getStreamSerialNumber())) == null) {
                        object = new LogicalOggStreamImpl(UncachedUrlStream.this, oggPage.getStreamSerialNumber());
                        UncachedUrlStream.this.logicalStreams.put(new Integer(oggPage.getStreamSerialNumber()), object);
                        ((LogicalOggStreamImpl)object).checkFormat(oggPage);
                    }
                    ++this.pageNumber;
                    while (this.pageCache.size() > 10) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            catch (EndOfOggStreamException endOfOggStreamException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public boolean isBosDone() {
            return this.bosDone;
        }
    }
}

